/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.deploy;

import com.atlassian.bamboo.plugins.confdeploy.AutoDeployConfigurator;
import com.atlassian.bamboo.plugins.confdeploy.config.RemoteProductType;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.webwork.util.WwSelectOption;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PluginDeployConfigurator
extends AutoDeployConfigurator {
    @Override
    protected RemoteProductType getProduct() {
        return RemoteProductType.JIRA;
    }

    @Override
    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        this.addProductTypes(context);
        context.put("multiProduct", true);
    }

    @Override
    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        this.addProductTypes(context);
        context.put("multiProduct", true);
    }

    private void addProductTypes(Map<String, Object> context) {
        RemoteProductType[] all = RemoteProductType.values();
        ArrayList allProducts = Lists.newArrayList((Iterable)Iterables.transform((Iterable)Lists.newArrayList((Object[])all), (Function)new Function<RemoteProductType, WwSelectOption>(){

            public WwSelectOption apply(RemoteProductType remoteProductType) {
                return new WwSelectOption(PluginDeployConfigurator.this.getI18nBeanForActionLocale().getText(remoteProductType.getProductKey()), "", remoteProductType.getProductKey());
            }
        }));
        context.put("allProducts", allProducts);
    }
}

