/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.confdeploy.upload.http;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.plugins.confdeploy.Result;
import com.atlassian.bamboo.plugins.confdeploy.config.TaskConfiguration;
import com.atlassian.bamboo.plugins.confdeploy.upload.http.BuildLoggingRequestInterceptor;
import com.atlassian.bamboo.plugins.confdeploy.upload.http.BuildLoggingResponseInterceptor;
import com.atlassian.bamboo.plugins.confdeploy.upload.http.HttpClientWrapper;
import com.atlassian.fugue.Either;
import com.atlassian.util.concurrent.Timeout;
import com.google.common.base.Function;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;

public class DefaultHttpClientWrapper
implements HttpClientWrapper {
    private final BuildLogger buildLogger;
    private final HttpClient client;

    public DefaultHttpClientWrapper(BuildLogger buildLogger, TaskConfiguration taskConfiguration) {
        this.buildLogger = buildLogger;
        this.client = this.initClient(taskConfiguration);
    }

    private HttpClient initClient(TaskConfiguration taskConfiguration) {
        DefaultHttpClient client = new DefaultHttpClient();
        if (taskConfiguration.allowSSLCertificateErrors()) {
            this.buildLogger.addBuildLogEntry("SSL Certificate check: disabled");
            try {
                X509TrustManager tm = new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
                        for (X509Certificate cert : certs) {
                            DefaultHttpClientWrapper.this.buildLogger.addBuildLogEntry("Automatically accepting client certificate: " + cert.getSubjectDN());
                        }
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
                        for (X509Certificate cert : certs) {
                            DefaultHttpClientWrapper.this.buildLogger.addBuildLogEntry("Automatically accepting server certificate: " + cert.getSubjectDN());
                        }
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }
                };
                SSLContext ctx = SSLContext.getInstance("TLS");
                ctx.init(null, new TrustManager[]{tm}, null);
                SSLSocketFactory ssf = new SSLSocketFactory(ctx, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
                ClientConnectionManager ccm = client.getConnectionManager();
                SchemeRegistry sr = ccm.getSchemeRegistry();
                sr.register(new Scheme("https", 443, (SchemeSocketFactory)ssf));
            }
            catch (NoSuchAlgorithmException e) {
                this.buildLogger.addErrorLogEntry("Could not find SSL Context for algorithm: TLS", (Throwable)e);
            }
            catch (KeyManagementException e) {
                this.buildLogger.addErrorLogEntry("Could not register custom TrustManager: " + e.getMessage(), (Throwable)e);
            }
        } else {
            this.buildLogger.addBuildLogEntry("SSL Certificate check: enabled");
        }
        if (taskConfiguration.getEnableTrafficLogging()) {
            client.addRequestInterceptor((HttpRequestInterceptor)new BuildLoggingRequestInterceptor(this.buildLogger, taskConfiguration));
            client.addResponseInterceptor((HttpResponseInterceptor)new BuildLoggingResponseInterceptor(this.buildLogger, taskConfiguration), 0);
        }
        client.getParams().setParameter("http.protocol.cookie-policy", (Object)"compatibility");
        BasicCookieStore cookieStore = new BasicCookieStore();
        client.setCookieStore((CookieStore)cookieStore);
        return client;
    }

    @Override
    public Result execute(HttpUriRequest request, ResponseHandler<Result> responseHandler) {
        try {
            return (Result)this.client.execute(request, responseHandler);
        }
        catch (IOException e) {
            return Result.failure("HTTP Request failed - an I/O Exception occurred: " + e.getMessage(), e);
        }
    }

    @Override
    public Result poll(HttpUriRequest initialRequest, final Function<HttpResponse, Either<HttpUriRequest, Result>> evaluator, Timeout timeout) {
        try {
            Either nextAction = (Either)this.client.execute(initialRequest, (ResponseHandler)new ResponseHandler<Either<HttpUriRequest, Result>>(){

                public Either<HttpUriRequest, Result> handleResponse(HttpResponse response) throws IOException {
                    return (Either)evaluator.apply((Object)response);
                }
            });
            if (nextAction.isLeft()) {
                if (timeout.isExpired()) {
                    return Result.failure("Polling request did not complete within the timeout.");
                }
                return this.poll((HttpUriRequest)nextAction.left().get(), evaluator, timeout);
            }
            return (Result)nextAction.right().get();
        }
        catch (IOException e) {
            return Result.failure("HTTP Request failed - an I/O Exception occurred: " + e.getMessage(), e);
        }
    }
}

