/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.confdeploy.upload.behaviour.upm;

import com.atlassian.bamboo.plugins.confdeploy.Failure;
import com.atlassian.bamboo.plugins.confdeploy.Result;
import com.atlassian.bamboo.plugins.confdeploy.Success;
import com.atlassian.bamboo.plugins.confdeploy.UrlUtils;
import com.atlassian.bamboo.plugins.confdeploy.config.TaskConfiguration;
import com.atlassian.bamboo.plugins.confdeploy.upload.behaviour.RequestBehaviour;
import com.atlassian.fugue.Either;
import java.io.IOException;
import java.util.Map;
import java.util.Random;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;

public class UpmTokenRequestBehaviour
implements RequestBehaviour {
    private static final String UPM_TOKEN_HEADER = "upm-token";
    private static final Random RAND = new Random();

    @Override
    public Either<HttpUriRequest, Failure> getRequest(TaskConfiguration configuration, Map<String, Object> requestContext) {
        String requestUrl = UrlUtils.join(configuration.getRemoteBaseUrl(), "/rest/plugins/1.0/?_=" + RAND.nextLong());
        HttpGet upmGet = new HttpGet(requestUrl);
        upmGet.addHeader("Accept", "application/vnd.atl.plugins.installed+json");
        return Either.left((Object)upmGet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result handleResponse(HttpResponse response) throws IOException {
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 401) {
                Failure failure = Result.failure("Unauthorized attempt to obtain XSRF token from plugin manager. Your configured user account is not a system administrator in the remote system.");
                return failure;
            }
            Header[] tokenHeaders = response.getHeaders(UPM_TOKEN_HEADER);
            if (tokenHeaders == null || tokenHeaders.length != 1) {
                Failure failure = Result.failure("Attempt to obtain XSRF token from plugin manager failed - the token was missing from the response. Has the plugin manager been disabled on the remote system?");
                return failure;
            }
            String upmToken = tokenHeaders[0].getValue();
            Success success = Result.success("", upmToken);
            return success;
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
    }
}

