/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.confdeploy.upload.behaviour.upm;

import com.atlassian.bamboo.plugins.confdeploy.Failure;
import com.atlassian.bamboo.plugins.confdeploy.Result;
import com.atlassian.bamboo.plugins.confdeploy.UrlUtils;
import com.atlassian.bamboo.plugins.confdeploy.config.TaskConfiguration;
import com.atlassian.bamboo.plugins.confdeploy.upload.behaviour.PollingRequestBehaviour;
import com.atlassian.fugue.Either;
import java.util.Map;
import java.util.Random;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

public class UpmSelfUpdateCheckBehaviour
implements PollingRequestBehaviour {
    private static final Random RAND = new Random();
    private final String baseUrl;

    public UpmSelfUpdateCheckBehaviour(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    public Either<HttpUriRequest, Failure> getRequest(TaskConfiguration configuration, Map<String, Object> requestContext) {
        return Either.left((Object)this.getRequestInternal());
    }

    public Either<HttpUriRequest, Result> apply(HttpResponse response) {
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            return Either.right((Object)Result.failure("Interrupted while waiting for UPM to self-update", e));
        }
        if (response.getStatusLine().getStatusCode() == 404) {
            return Either.left((Object)this.getRequestInternal());
        }
        return Either.right((Object)Result.success("UPM self-update is complete"));
    }

    private HttpUriRequest getRequestInternal() {
        String pollUrl = UrlUtils.join(this.baseUrl, "/rest/plugins/1.0/?_=" + RAND.nextLong());
        HttpGet pollGet = new HttpGet(pollUrl);
        pollGet.addHeader("Accept", "*/*");
        return pollGet;
    }
}

