/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.confdeploy.upload.behaviour.upm;

import com.atlassian.bamboo.plugins.confdeploy.Failure;
import com.atlassian.bamboo.plugins.confdeploy.Result;
import com.atlassian.bamboo.plugins.confdeploy.Success;
import com.atlassian.bamboo.plugins.confdeploy.UrlUtils;
import com.atlassian.bamboo.plugins.confdeploy.config.TaskConfiguration;
import com.atlassian.bamboo.plugins.confdeploy.upload.behaviour.RequestBehaviour;
import com.atlassian.fugue.Either;
import java.io.IOException;
import java.util.Map;
import java.util.Random;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;

public class UpmSelfUpdateBehaviour
implements RequestBehaviour {
    private static final Random RAND = new Random();
    private final String baseUrl;

    public UpmSelfUpdateBehaviour(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    public Either<HttpUriRequest, Failure> getRequest(TaskConfiguration configuration, Map<String, Object> requestContext) {
        String requestUrl = UrlUtils.join(this.baseUrl, "/rest/plugins/self-update/1.0/?_=" + RAND.nextLong());
        return Either.left((Object)new HttpPost(requestUrl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result handleResponse(HttpResponse response) throws IOException {
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 201) {
                Failure failure = Result.failure("UPM Self-update failed. HTTP status code " + statusCode + " was returned.");
                return failure;
            }
            Success success = Result.success("UPM Self-update succeeded!");
            return success;
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
    }
}

