/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.confdeploy.upload.behaviour.upm;

import com.atlassian.bamboo.plugins.confdeploy.Failure;
import com.atlassian.bamboo.plugins.confdeploy.Result;
import com.atlassian.bamboo.plugins.confdeploy.UrlUtils;
import com.atlassian.bamboo.plugins.confdeploy.config.TaskConfiguration;
import com.atlassian.bamboo.plugins.confdeploy.upload.behaviour.PollingRequestBehaviour;
import com.atlassian.fugue.Either;
import java.io.IOException;
import java.util.Map;
import java.util.Random;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class UploadSuccessCheckBehaviour
implements PollingRequestBehaviour {
    private static final int DEFAULT_POLL_DELAY_MS = 1000;
    private static final Random RAND = new Random();
    private final String hostUrl;
    private final int minimumPollDelay;

    public UploadSuccessCheckBehaviour(TaskConfiguration taskConfiguration) {
        String baseUrl = taskConfiguration.getRemoteBaseUrl();
        this.hostUrl = UrlUtils.getHostUrl(baseUrl);
        if (taskConfiguration.getPluginInstallationTimeout() == 90) {
            this.minimumPollDelay = 1000;
        } else {
            double proportion = taskConfiguration.getPluginInstallationTimeout() / 90;
            this.minimumPollDelay = new Double(Math.floor(1000.0 * proportion)).intValue();
        }
    }

    @Override
    public Either<HttpUriRequest, Failure> getRequest(TaskConfiguration configuration, Map<String, Object> requestContext) {
        if (!requestContext.containsKey("responseEntity")) {
            return Either.right((Object)Result.failure("Could not check plugin install status - the JSON Response entity is missing (probably a bug!)"));
        }
        JSONObject responseEntity = (JSONObject)requestContext.get("responseEntity");
        return this.getRequestInternal(responseEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Either<HttpUriRequest, Result> apply(HttpResponse response) {
        try {
            try {
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    Either<HttpUriRequest, Failure> request;
                    String entity = EntityUtils.toString((HttpEntity)response.getEntity());
                    JSONObject j = new JSONObject(entity);
                    if (!j.has("pingAfter")) {
                        Either either = Either.right((Object)Result.success("Plugin installed successfully"));
                        return either;
                    }
                    int pingAfter = j.getInt("pingAfter");
                    int delay = Math.max(pingAfter, this.minimumPollDelay);
                    Thread.sleep(delay);
                    Either<HttpUriRequest, Failure> either = request = this.getRequestInternal(j);
                    return either;
                }
                if (statusCode >= 400) {
                    Either either = Either.right((Object)Result.failure("Unexpected response code when polling upload: " + statusCode));
                    return either;
                }
                Either either = Either.right((Object)Result.success("Plugin installed successfully!"));
                return either;
            }
            finally {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
        catch (IOException e) {
            return Either.right((Object)Result.failure(e.getMessage(), e));
        }
        catch (JSONException e) {
            return Either.right((Object)Result.failure(e.getMessage(), (Exception)((Object)e)));
        }
        catch (InterruptedException e) {
            return Either.right((Object)Result.failure(e.getMessage(), e));
        }
    }

    private Either<HttpUriRequest, Failure> getRequestInternal(JSONObject responseEntity) {
        String requestUrl;
        try {
            requestUrl = UrlUtils.join(this.hostUrl, responseEntity.getJSONObject("links").getString("self") + "?_=" + RAND.nextLong());
        }
        catch (JSONException e) {
            return Either.right((Object)Result.failure("Failed to get the polling link from the JSON response.", (Exception)((Object)e)));
        }
        HttpGet request = new HttpGet(requestUrl);
        request.addHeader("Accept", "*/*");
        return Either.left((Object)request);
    }
}

