/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.confdeploy.upload.behaviour.lasso;

import com.atlassian.bamboo.plugins.confdeploy.Failure;
import com.atlassian.bamboo.plugins.confdeploy.Result;
import com.atlassian.bamboo.plugins.confdeploy.Success;
import com.atlassian.bamboo.plugins.confdeploy.UrlUtils;
import com.atlassian.bamboo.plugins.confdeploy.config.TaskConfiguration;
import com.atlassian.bamboo.plugins.confdeploy.upload.behaviour.RequestBehaviour;
import com.atlassian.fugue.Either;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class AtlassianIdWebSudoRequestBehaviour
implements RequestBehaviour {
    @Override
    public Either<HttpUriRequest, Failure> getRequest(TaskConfiguration configuration, Map<String, Object> requestContext) {
        String appNameEncoded;
        Validate.notEmpty((String)configuration.getAtlassianIdBaseUrl());
        Validate.notEmpty((String)configuration.getAtlassianIdAppName());
        Validate.notEmpty((String)configuration.getAtlassianIdUsername());
        Validate.notEmpty((String)configuration.getAtlassianIdPassword());
        try {
            appNameEncoded = URLEncoder.encode(configuration.getAtlassianIdAppName(), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        String requestUrl = UrlUtils.join(configuration.getAtlassianIdBaseUrl(), "/id/websudo.action?application=" + appNameEncoded);
        HttpPost request = new HttpPost(requestUrl);
        try {
            request.setEntity((HttpEntity)new UrlEncodedFormEntity((List)Lists.newArrayList((Object[])new NameValuePair[]{new BasicNameValuePair("username", configuration.getAtlassianIdUsername()), new BasicNameValuePair("password", configuration.getAtlassianIdPassword()), new BasicNameValuePair("websudo", "false")})));
        }
        catch (UnsupportedEncodingException e) {
            return Either.right((Object)Result.failure("Failed to encode UTF-8 String - Java, you suck.", e));
        }
        return Either.left((Object)request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result handleResponse(HttpResponse response) throws IOException {
        try {
            int responseCode = response.getStatusLine().getStatusCode();
            if (responseCode == 302) {
                Success success = Result.success("Atlassian ID WebSudo complete!");
                return success;
            }
            Failure failure = Result.failure("Atlassian ID WebSudo failed. HTTP status " + responseCode + " was returned (note: HTTP 200 OK is a failure in this case");
            return failure;
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
    }
}

