/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.confdeploy.upload.behaviour.lasso;

import com.atlassian.bamboo.plugins.confdeploy.Failure;
import com.atlassian.bamboo.plugins.confdeploy.Result;
import com.atlassian.bamboo.plugins.confdeploy.Success;
import com.atlassian.bamboo.plugins.confdeploy.UrlUtils;
import com.atlassian.bamboo.plugins.confdeploy.config.TaskConfiguration;
import com.atlassian.bamboo.plugins.confdeploy.upload.behaviour.RequestBehaviour;
import com.atlassian.fugue.Either;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class AtlassianIdLoginRequestBehaviour
implements RequestBehaviour {
    private static final String LOGIN_RELATIVE_URL = "/id/rest/login";

    @Override
    public Either<HttpUriRequest, Failure> getRequest(TaskConfiguration configuration, Map<String, Object> requestContext) {
        Validate.notEmpty((String)configuration.getAtlassianIdUsername(), (String)"Atlassian ID Username must be specified to authenticate with Atlassian ID.");
        Validate.notEmpty((String)configuration.getAtlassianIdPassword(), (String)"Atlassian ID Password must be specified to authenticate with Atlassian ID.");
        Validate.notEmpty((String)configuration.getAtlassianIdBaseUrl(), (String)"Atlassian ID Base URL must be specified to authenticate with Atlassian ID.");
        String loginUrl = UrlUtils.join(configuration.getAtlassianIdBaseUrl(), LOGIN_RELATIVE_URL);
        HttpPost loginRequest = new HttpPost(loginUrl);
        loginRequest.addHeader("Accept", "application/json");
        try {
            JSONObject j = new JSONObject();
            j.put("username", (Object)configuration.getAtlassianIdUsername());
            j.put("password", (Object)configuration.getAtlassianIdPassword());
            loginRequest.setEntity((HttpEntity)new StringEntity(j.toString(), "application/json", "utf-8"));
        }
        catch (JSONException e) {
            return Either.right((Object)Result.failure("Failed to construct JSON request body: " + e.getMessage(), (Exception)((Object)e)));
        }
        catch (UnsupportedEncodingException e) {
            return Either.right((Object)Result.failure("Failed to encode UTF-8 String - Java, you suck.", e));
        }
        return Either.left((Object)loginRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result handleResponse(HttpResponse response) throws IOException {
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 403) {
                Failure failure = Result.failure("Sorry, your Atlassian ID credentials were incorrect.");
                return failure;
            }
            if (statusCode == 200) {
                Success success = Result.success("Login to Atlassian ID was successful.");
                return success;
            }
            Failure failure = Result.failure("Atlassian ID login failed. HTTP Status code " + statusCode + " returned.");
            return failure;
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
    }
}

