/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.confdeploy.upload.behaviour;

import com.atlassian.bamboo.plugins.confdeploy.Failure;
import com.atlassian.bamboo.plugins.confdeploy.Result;
import com.atlassian.bamboo.plugins.confdeploy.Success;
import com.atlassian.bamboo.plugins.confdeploy.config.TaskConfiguration;
import com.atlassian.bamboo.plugins.confdeploy.upload.behaviour.RequestBehaviour;
import com.atlassian.fugue.Either;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public abstract class ProductWebSudoRequestBehaviour
implements RequestBehaviour {
    private static final String ENCODING = "utf-8";
    private final String webSudoUrl;
    private final String passwordFieldName;

    public ProductWebSudoRequestBehaviour(String webSudoUrl, String passwordFieldName) {
        this.webSudoUrl = webSudoUrl;
        this.passwordFieldName = passwordFieldName;
    }

    @Override
    public Either<HttpUriRequest, Failure> getRequest(TaskConfiguration configuration, Map<String, Object> requestContext) {
        UrlEncodedFormEntity entity;
        ArrayList<BasicNameValuePair> values = new ArrayList<BasicNameValuePair>();
        values.add(new BasicNameValuePair(this.passwordFieldName, configuration.getPassword()));
        values.add(new BasicNameValuePair("authenticate", "Confirm"));
        try {
            entity = new UrlEncodedFormEntity(values, ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            return Either.right((Object)Result.failure("Failed to encode UTF-8 String - Java, you suck.", e));
        }
        HttpPost webSudoPost = new HttpPost(this.webSudoUrl);
        webSudoPost.addHeader("Accept", "*");
        webSudoPost.addHeader("X-Atlassian-Token", "no-check");
        webSudoPost.setEntity((HttpEntity)entity);
        return Either.left((Object)webSudoPost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result handleResponse(HttpResponse response) throws IOException {
        try {
            Header[] webSudoHeaders = response.getHeaders("X-Atlassian-WebSudo");
            if (webSudoHeaders == null || webSudoHeaders.length != 1) {
                Failure failure = Result.failure("WebSudo authentication failed; Your password was incorrect.");
                return failure;
            }
            String webSudoHeader = webSudoHeaders[0].getValue();
            if (!webSudoHeader.equals("Has-Authentication")) {
                Failure failure = Result.failure("WebSudo authentication failed. The 'X-Atlassian-WebSudo' response header did not contain the expected value ('Has-Authentication').");
                return failure;
            }
            Success success = Result.success("WebSudo authentication successful!");
            return success;
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
    }
}

