/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.confdeploy.upload;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.plugins.confdeploy.config.RemoteProductType;
import com.atlassian.bamboo.plugins.confdeploy.config.TaskConfiguration;
import com.atlassian.bamboo.plugins.confdeploy.upload.DefaultUploadClient;
import com.atlassian.bamboo.plugins.confdeploy.upload.UploadClientFactory;
import com.atlassian.bamboo.plugins.confdeploy.upload.behaviour.RequestBehaviour;
import com.atlassian.bamboo.plugins.confdeploy.upload.behaviour.lasso.AtlassianIdLoginRequestBehaviour;
import com.atlassian.bamboo.plugins.confdeploy.upload.behaviour.lasso.AtlassianIdWebSudoRequestBehaviour;
import com.atlassian.bamboo.plugins.confdeploy.upload.behaviour.product.BambooLoginRequestBehaviour;
import com.atlassian.bamboo.plugins.confdeploy.upload.behaviour.product.ConfluenceLoginRequestBehaviour;
import com.atlassian.bamboo.plugins.confdeploy.upload.behaviour.product.ConfluenceWebSudoRequestBehaviour;
import com.atlassian.bamboo.plugins.confdeploy.upload.behaviour.product.FeCruLoginRequestBehaviour;
import com.atlassian.bamboo.plugins.confdeploy.upload.behaviour.product.JiraLoginRequestBehaviour;
import com.atlassian.bamboo.plugins.confdeploy.upload.behaviour.product.JiraPermissionCheckBehaviour;
import com.atlassian.bamboo.plugins.confdeploy.upload.behaviour.product.JiraWebSudoRequestBehaviour;
import com.atlassian.bamboo.plugins.confdeploy.upload.behaviour.product.StashLoginRequestBehaviour;
import com.atlassian.bamboo.plugins.confdeploy.upload.behaviour.upm.PluginUploadRequestBehaviour;
import com.atlassian.bamboo.plugins.confdeploy.upload.behaviour.upm.UploadSuccessCheckBehaviour;
import com.atlassian.bamboo.plugins.confdeploy.upload.behaviour.upm.UpmSelfUpdateBehaviour;
import com.atlassian.bamboo.plugins.confdeploy.upload.behaviour.upm.UpmSelfUpdateCheckBehaviour;
import com.atlassian.bamboo.plugins.confdeploy.upload.behaviour.upm.UpmTokenRequestBehaviour;
import com.atlassian.bamboo.plugins.confdeploy.upload.http.DefaultHttpClientWrapper;

public class DefaultUploadClientFactory
implements UploadClientFactory {
    @Override
    public DefaultUploadClient getUploadClient(RemoteProductType productType, TaskConfiguration taskConfiguration, BuildLogger buildLogger) {
        UpmSelfUpdateBehaviour upmSelfUpdateStrategy = null;
        UpmSelfUpdateCheckBehaviour upmSelfUpdateCheckStrategy = null;
        if (this.isUpm(taskConfiguration)) {
            upmSelfUpdateStrategy = new UpmSelfUpdateBehaviour(taskConfiguration.getRemoteBaseUrl());
            upmSelfUpdateCheckStrategy = new UpmSelfUpdateCheckBehaviour(taskConfiguration.getRemoteBaseUrl());
        }
        return new DefaultUploadClient(this.getLoginBehaviour(productType, taskConfiguration), this.getPermissionCheckStrategy(productType), this.getWebSudoBehaviour(productType, taskConfiguration), new UpmTokenRequestBehaviour(), new PluginUploadRequestBehaviour(), new UploadSuccessCheckBehaviour(taskConfiguration), upmSelfUpdateStrategy, upmSelfUpdateCheckStrategy, buildLogger, new DefaultHttpClientWrapper(buildLogger, taskConfiguration));
    }

    private boolean isUpm(TaskConfiguration taskConfiguration) {
        return taskConfiguration.getPluginJar().getName().startsWith("atlassian-universal-plugin-manager-plugin");
    }

    private RequestBehaviour getPermissionCheckStrategy(RemoteProductType productType) {
        switch (productType) {
            case JIRA: {
                return new JiraPermissionCheckBehaviour();
            }
        }
        return null;
    }

    private RequestBehaviour getWebSudoBehaviour(RemoteProductType productType, TaskConfiguration taskConfiguration) {
        if (!productType.getSupportsWebSudo()) {
            return null;
        }
        if (taskConfiguration.useAtlassianId() && taskConfiguration.useAtlassianIdWebSudo()) {
            return new AtlassianIdWebSudoRequestBehaviour();
        }
        if (productType == RemoteProductType.CONFLUENCE) {
            return new ConfluenceWebSudoRequestBehaviour(taskConfiguration.getRemoteBaseUrl());
        }
        if (productType == RemoteProductType.JIRA) {
            return new JiraWebSudoRequestBehaviour(taskConfiguration.getRemoteBaseUrl());
        }
        return null;
    }

    private RequestBehaviour getLoginBehaviour(RemoteProductType productType, TaskConfiguration taskConfiguration) {
        RequestBehaviour loginBehaviour;
        if (taskConfiguration.useAtlassianId()) {
            loginBehaviour = new AtlassianIdLoginRequestBehaviour();
        } else if (productType == RemoteProductType.CONFLUENCE) {
            loginBehaviour = new ConfluenceLoginRequestBehaviour(taskConfiguration.getRemoteBaseUrl());
        } else if (productType == RemoteProductType.JIRA) {
            loginBehaviour = new JiraLoginRequestBehaviour(taskConfiguration.getRemoteBaseUrl());
        } else if (productType == RemoteProductType.BAMBOO) {
            loginBehaviour = new BambooLoginRequestBehaviour(taskConfiguration.getRemoteBaseUrl());
        } else if (productType == RemoteProductType.FECRU) {
            loginBehaviour = new FeCruLoginRequestBehaviour(taskConfiguration.getRemoteBaseUrl());
        } else if (productType == RemoteProductType.STASH) {
            loginBehaviour = new StashLoginRequestBehaviour(taskConfiguration.getRemoteBaseUrl());
        } else {
            throw new RuntimeException(String.format("Unknown RemoteProductType %s", new Object[]{productType}));
        }
        return loginBehaviour;
    }
}

