/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.confdeploy.config.ui;

import com.atlassian.bamboo.plan.artifact.ArtifactDefinition;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionManager;
import com.atlassian.bamboo.plugins.confdeploy.AvailableArtifact;
import com.atlassian.bamboo.plugins.confdeploy.config.ui.ConfigurationValidator;
import com.atlassian.bamboo.plugins.confdeploy.config.ui.TaskParametersMap;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.i18n.I18nBean;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang.StringUtils;

public class DefaultConfigurationValidator
implements ConfigurationValidator {
    private final ArtifactDefinitionManager artifactDefinitionManager;
    private final I18nBean i18nBean;

    public DefaultConfigurationValidator(I18nBean i18nBean, ArtifactDefinitionManager artifactDefinitionManager) {
        this.i18nBean = i18nBean;
        this.artifactDefinitionManager = artifactDefinitionManager;
    }

    private void validatePassword(boolean usePasswordVariable, String passwordVariable, String password, ErrorCollection errors) {
        if (usePasswordVariable) {
            if (StringUtils.isBlank((String)passwordVariable)) {
                errors.addErrorMessage(this.i18nBean.getText("bcpd.config.form.password.error.required"));
            } else if (!this.isBambooVariable(passwordVariable)) {
                errors.addErrorMessage(this.i18nBean.getText("bcpd.config.form.password.error.invalid"));
            }
        } else if (StringUtils.isBlank((String)password)) {
            errors.addErrorMessage(this.i18nBean.getText("bcpd.config.form.password.error.required"));
        }
    }

    private boolean isBambooVariable(String fieldValue) {
        return StringUtils.isNotBlank((String)fieldValue) && fieldValue.startsWith("${bamboo.");
    }

    private boolean validateNotBlank(String fieldName, String fieldValue, String errorKey, ErrorCollection errors) {
        if (StringUtils.isBlank((String)fieldValue)) {
            if (StringUtils.isBlank((String)fieldName)) {
                errors.addErrorMessage(this.i18nBean.getText(errorKey));
            } else {
                errors.addError(fieldName, this.i18nBean.getText(errorKey));
            }
            return false;
        }
        return true;
    }

    private boolean validateIsUrl(String fieldName, String fieldValue, String errorKey, ErrorCollection errors) {
        if (this.isBambooVariable(fieldValue)) {
            return true;
        }
        try {
            new URL(fieldValue);
            return true;
        }
        catch (MalformedURLException e) {
            if (StringUtils.isBlank((String)fieldName)) {
                errors.addErrorMessage(this.i18nBean.getText(errorKey));
            } else {
                errors.addError(fieldName, this.i18nBean.getText(errorKey));
            }
            return false;
        }
    }

    @Override
    public void validate(TaskParametersMap config, ErrorCollection errors) {
        if (!this.validateNotBlank("bcpd_config_artifact", config.getArtifact(), "bcpd.config.form.artifact.error.required", errors)) {
            errors.addError("bcpd_config_artifact_name", this.i18nBean.getText("bcpd.config.form.artifact.error.required"));
        } else {
            try {
                AvailableArtifact artifact = new AvailableArtifact(config.getArtifact());
                ArtifactDefinition artifactDefinition = this.artifactDefinitionManager.findArtifactDefinition(artifact.getArtifactId().longValue());
                if (artifactDefinition == null) {
                    errors.addError("bcpd_config_artifact", this.i18nBean.getText("bcpd.config.form.artifact.error.invalid", (Object[])new String[]{artifact.getName()}));
                }
            }
            catch (IllegalArgumentException e) {
                errors.addError("bcpd_config_artifact", this.i18nBean.getText("bcpd.config.form.artifact.error.invalid", (Object[])new String[]{config.getArtifact()}));
            }
        }
        if (this.validateNotBlank("bcpd_config_baseUrl", config.getBaseUrl(), "bcpd.config.form.baseUrl.error.required", errors)) {
            this.validateIsUrl("bcpd_config_baseUrl", config.getBaseUrl(), "bcpd.config.form.baseUrl.error.invalid", errors);
        }
        if (config.useAtlassianId()) {
            if (!StringUtils.isBlank((String)config.getAtlassianIdBaseUrl())) {
                this.validateIsUrl("", config.getAtlassianIdBaseUrl(), "bcpd.config.form.atlassianIdUrl.error.invalid", errors);
            }
            this.validateNotBlank("", config.getAtlassianIdUsername(), "bcpd.config.form.username.error.required", errors);
            this.validatePassword(config.useAtlassianIdPasswordVariable(), config.getAtlassianIdPasswordVariable(), config.getAtlassianIdPassword(), errors);
            if (config.useAtlassianIdWebSudo()) {
                this.validateNotBlank("", config.getAtlassianIdAppName(), "bcpd.config.form.appname.error.required", errors);
            } else {
                this.validatePassword(config.usePasswordVariable(), config.getPasswordVariable(), config.getPassword(), errors);
            }
        } else {
            this.validateNotBlank("", config.getUsername(), "bcpd.config.form.username.error.required", errors);
            this.validatePassword(config.usePasswordVariable(), config.getPasswordVariable(), config.getPassword(), errors);
        }
    }
}

