/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.confdeploy.config.ui;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plan.artifact.ImmutableArtifactSubscription;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plugins.confdeploy.AvailableArtifact;
import com.atlassian.bamboo.plugins.confdeploy.Crypto;
import com.atlassian.bamboo.plugins.confdeploy.config.ui.ConfigurationSerializer;
import com.atlassian.bamboo.plugins.confdeploy.config.ui.TaskParametersMap;
import com.atlassian.bamboo.task.TaskContextHelper;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.fugue.Pair;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConfigurationSerializer
implements ConfigurationSerializer {
    static final String SAVED_PASSWORD_IDENTIFIER = "397ef670-6140-11e3-949a-0800200c9a66";
    private static final Logger log = LoggerFactory.getLogger(DefaultConfigurationSerializer.class);
    private static final Map<String, DeserializationInfo> FIELD_MAPPINGS;

    @Override
    public Map<String, String> serializeTaskContext(TaskParametersMap params, TaskDefinition taskDefinition) {
        HashMap config = Maps.newHashMap();
        config.put("bcpd.config.productType", params.getProduct());
        config.put("confDeployURL", params.getBaseUrl());
        config.put("confDeployUsername", params.getUsername());
        config.put("deployBranchEnabled", String.valueOf(params.getAllowBranchBuilds()));
        this.persistPassword(taskDefinition, params.getAll(), config, "bcpd_config_usePasswordVariable", "bcpd_config_passwordVariable", "bcpd_config_password", "confDeployPasswordVariableCheck", "confDeployPasswordVariable", "confDeployPassword", "confDeployKey");
        boolean useAtlassianId = params.useAtlassianId();
        config.put("useAtlassianId", String.valueOf(useAtlassianId));
        if (useAtlassianId) {
            config.put("atlassianIdBaseURL", params.getAtlassianIdBaseUrl());
            config.put("atlassianIdUsername", params.getAtlassianIdUsername());
            config.put("useAtlassianIdWebSudo", String.valueOf(params.useAtlassianIdWebSudo()));
            config.put("atlassianIdAppName", params.getAtlassianIdAppName());
            this.persistPassword(taskDefinition, params.getAll(), config, "bcpd_config_useAtlassianIdPasswordVariable", "bcpd_config_atlassianIdPasswordVariable", "bcpd_config_atlassianIdPassword", "atlassianIdPasswordVariableCheck", "atlassianIdPasswordVariable", "atlassianIdPassword", "atlassianIdKey");
        }
        config.put("confDeployJar", params.getArtifact());
        config.put("certificateCheckDisabled", String.valueOf(params.getAllowCertificateErrors()));
        config.put("enableTrafficLogging", String.valueOf(params.getTrafficDump()));
        int timeout = params.getPluginInstallationTimeout();
        if (timeout != -1 && timeout != 90) {
            config.put("pluginInstallationTimeout", String.valueOf(timeout));
        }
        return config;
    }

    private void persistPassword(TaskDefinition task, ActionParametersMap source, Map<String, String> destination, String sourceVariableCheckKey, String sourceVariableKey, String sourcePasswordKey, String destVariableCheckKey, String destVariableKey, String destPasswordKey, String destEncryptionKeyKey) {
        boolean persistPassword;
        String rawPassword = source.getString(sourcePasswordKey);
        boolean persistPasswordVariable = source.containsKey((Object)sourceVariableCheckKey) && source.getBoolean(sourceVariableCheckKey);
        boolean bl = persistPassword = source.containsKey((Object)sourcePasswordKey) && StringUtils.isNotBlank((String)rawPassword);
        if (persistPasswordVariable) {
            destination.put(destVariableCheckKey, Boolean.toString(true));
            destination.put(destVariableKey, source.getString(sourceVariableKey));
            destination.put(destEncryptionKeyKey, "");
            destination.put(destPasswordKey, "");
        } else if (persistPassword) {
            if (rawPassword == null) {
                throw new UnsupportedOperationException("Cannot persist empty password");
            }
            if (rawPassword.equals(SAVED_PASSWORD_IDENTIFIER)) {
                destination.put(destVariableCheckKey, Boolean.toString(false));
                destination.put(destVariableKey, "");
                destination.put(destEncryptionKeyKey, (String)task.getConfiguration().get(destEncryptionKeyKey));
                destination.put(destPasswordKey, (String)task.getConfiguration().get(destPasswordKey));
            } else {
                Pair<String, String> encryptedPassword = Crypto.encrypt(rawPassword);
                destination.put(destVariableCheckKey, Boolean.toString(false));
                destination.put(destVariableKey, "");
                destination.put(destEncryptionKeyKey, (String)encryptedPassword.left());
                destination.put(destPasswordKey, (String)encryptedPassword.right());
            }
        } else {
            destination.put(destVariableCheckKey, Boolean.toString(false));
            destination.put(destVariableKey, "");
            destination.put(destEncryptionKeyKey, "");
            destination.put(destPasswordKey, "");
        }
    }

    @Override
    public void deserializeTaskContext(Map<String, Object> context, TaskDefinition taskDefinition) {
        this.upgradeArtifactPersistence(context, taskDefinition);
        for (String key : FIELD_MAPPINGS.keySet()) {
            String value = (String)taskDefinition.getConfiguration().get(key);
            DeserializationInfo info = FIELD_MAPPINGS.get(key);
            if (info.isEncrypted() && !StringUtils.isBlank((String)value)) {
                context.put(info.getKey(), SAVED_PASSWORD_IDENTIFIER);
                continue;
            }
            context.put(info.getKey(), value);
        }
    }

    private void upgradeArtifactPersistence(Map<String, Object> context, TaskDefinition taskDefinition) {
        ImmutableJob job = (ImmutableJob)Narrow.reinterpret((Object)TaskContextHelper.getPlan(context), ImmutableJob.class);
        if (job == null) {
            return;
        }
        String persistedArtifactName = (String)taskDefinition.getConfiguration().get("confDeployJar");
        if (persistedArtifactName.startsWith("v2:")) {
            return;
        }
        String newPersistedArtifactName = null;
        for (ImmutableArtifactSubscription subscription : job.getArtifactSubscriptions()) {
            if (!subscription.getArtifactDefinition().getName().equals(persistedArtifactName)) continue;
            newPersistedArtifactName = AvailableArtifact.from(subscription).toString();
            break;
        }
        if (newPersistedArtifactName == null) {
            log.error(String.format("Unable to locate artifact subscription named %s - the stored artifact format could not be updated. You probably won't be able to save this Task.", persistedArtifactName));
        } else {
            log.debug(String.format("Updating Artifact Subscription details from %s to %s", persistedArtifactName, newPersistedArtifactName));
            taskDefinition.getConfiguration().put("confDeployJar", newPersistedArtifactName);
        }
    }

    static {
        ImmutableMap.Builder b = ImmutableMap.builder();
        b.put((Object)"confDeployJar", (Object)new DeserializationInfo("bcpd_config_artifact"));
        b.put((Object)"confDeployURL", (Object)new DeserializationInfo("bcpd_config_baseUrl"));
        b.put((Object)"confDeployUsername", (Object)new DeserializationInfo("bcpd_config_username"));
        b.put((Object)"confDeployPasswordVariableCheck", (Object)new DeserializationInfo("bcpd_config_usePasswordVariable"));
        b.put((Object)"confDeployPassword", (Object)new DeserializationInfo("bcpd_config_password", true));
        b.put((Object)"confDeployPasswordVariable", (Object)new DeserializationInfo("bcpd_config_passwordVariable"));
        b.put((Object)"useAtlassianId", (Object)new DeserializationInfo("bcpd_config_useAtlassianId"));
        b.put((Object)"atlassianIdUsername", (Object)new DeserializationInfo("bcpd_config_atlassianIdUsername"));
        b.put((Object)"atlassianIdPassword", (Object)new DeserializationInfo("bcpd_config_atlassianIdPassword", true));
        b.put((Object)"atlassianIdPasswordVariableCheck", (Object)new DeserializationInfo("bcpd_config_useAtlassianIdPasswordVariable"));
        b.put((Object)"atlassianIdPasswordVariable", (Object)new DeserializationInfo("bcpd_config_atlassianIdPasswordVariable"));
        b.put((Object)"useAtlassianIdWebSudo", (Object)new DeserializationInfo("bcpd_config_useAtlassianIdWebSudo"));
        b.put((Object)"atlassianIdAppName", (Object)new DeserializationInfo("bcpd_config_atlassianIdAppName"));
        b.put((Object)"atlassianIdBaseURL", (Object)new DeserializationInfo("bcpd_config_atlassianIdBaseURL"));
        b.put((Object)"deployBranchEnabled", (Object)new DeserializationInfo("bcpd_config_branching"));
        b.put((Object)"certificateCheckDisabled", (Object)new DeserializationInfo("bcpd_config_ssl"));
        b.put((Object)"enableTrafficLogging", (Object)new DeserializationInfo("bcpd_config_logging"));
        b.put((Object)"pluginInstallationTimeout", (Object)new DeserializationInfo("bcpd_config_timeout"));
        b.put((Object)"bcpd.config.productType", (Object)new DeserializationInfo("bcpd_config_product"));
        FIELD_MAPPINGS = b.build();
    }

    private static class DeserializationInfo {
        private final String key;
        private final boolean isEncrypted;

        public DeserializationInfo(String key) {
            this.key = key;
            this.isEncrypted = false;
        }

        public DeserializationInfo(String key, boolean isEncrypted) {
            this.key = key;
            this.isEncrypted = isEncrypted;
        }

        public String getKey() {
            return this.key;
        }

        public boolean isEncrypted() {
            return this.isEncrypted;
        }
    }
}

