/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.confdeploy.config;

import javax.annotation.Nonnull;

public enum RemoteProductType {
    CONFLUENCE("bcpd.product.confluence", true),
    JIRA("bcpd.product.jira", true),
    BAMBOO("bcpd.product.bamboo", false),
    FECRU("bcpd.product.fecru", false),
    STASH("bcpd.product.stash", false);

    private final String displayKey;
    private final boolean supportsWebSudo;

    private RemoteProductType(String displayKey, boolean supportsWebSudo) {
        this.displayKey = displayKey;
        this.supportsWebSudo = supportsWebSudo;
    }

    public String getProductKey() {
        return this.displayKey;
    }

    public boolean getSupportsWebSudo() {
        return this.supportsWebSudo;
    }

    public static RemoteProductType fromKey(@Nonnull String productKey) {
        for (RemoteProductType type : RemoteProductType.values()) {
            if (!type.getProductKey().equals(productKey)) continue;
            return type;
        }
        return null;
    }
}

