/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.confdeploy.config;

import com.atlassian.bamboo.plan.artifact.ArtifactContext;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContext;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionContext;
import com.atlassian.bamboo.plugins.confdeploy.AvailableArtifact;
import com.atlassian.bamboo.plugins.confdeploy.Failure;
import com.atlassian.bamboo.plugins.confdeploy.Result;
import com.atlassian.bamboo.plugins.confdeploy.config.ArtifactRetriever;
import com.atlassian.bamboo.plugins.confdeploy.config.BaseArtifactRetriever;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Iterables;
import com.atlassian.fugue.Option;
import com.google.common.base.Predicate;
import java.io.File;

public class JobArtifactRetriever
extends BaseArtifactRetriever
implements ArtifactRetriever {
    private final ArtifactContext artifactContext;

    public JobArtifactRetriever(TaskContext taskContext, CustomVariableContext customVariableContext) {
        super((CommonTaskContext)taskContext, customVariableContext);
        this.artifactContext = taskContext.getBuildContext().getArtifactContext();
    }

    @Override
    public Either<File, Failure> getFileFromArtifact(final String artifactString) {
        AvailableArtifact artifactDesc;
        if (!AvailableArtifact.isValidStoredArtifact(artifactString)) {
            Option maybeArtifact = Iterables.findFirst((Iterable)this.artifactContext.getSubscriptionContexts(), (Predicate)new Predicate<ArtifactSubscriptionContext>(){

                public boolean apply(ArtifactSubscriptionContext artifactSubscriptionContext) {
                    ArtifactDefinitionContext artifactDefinitionContext = artifactSubscriptionContext.getArtifactDefinitionContext();
                    return artifactDefinitionContext.getName().equals(artifactString);
                }
            });
            if (maybeArtifact.isEmpty()) {
                return Either.right((Object)Result.failure("Unable to locate Artifact subscription named " + artifactString));
            }
            artifactDesc = AvailableArtifact.from((ArtifactSubscriptionContext)maybeArtifact.get());
        } else {
            artifactDesc = new AvailableArtifact(artifactString);
        }
        File pluginJar = artifactDesc.isFromTransferTask() ? this.getArtifactFromTransferTask(artifactDesc) : this.getArtifactFromJob(artifactDesc);
        if (pluginJar == null) {
            String msg = String.format("Unable to find the artifact with id %d in this task's context. Has an artifact subscription been configured for that artifact in this job?", artifactDesc.getArtifactId());
            return Either.right((Object)Result.failure(msg));
        }
        if (!pluginJar.exists() || !pluginJar.isFile()) {
            String msg = String.format("Artifact file %s is either missing or not a file.", pluginJar.getAbsolutePath());
            return Either.right((Object)Result.failure(msg));
        }
        return Either.left((Object)pluginJar);
    }
}

