/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.confdeploy.config;

import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.plugins.confdeploy.Crypto;
import com.atlassian.bamboo.plugins.confdeploy.Failure;
import com.atlassian.bamboo.plugins.confdeploy.config.ArtifactRetriever;
import com.atlassian.bamboo.plugins.confdeploy.config.DefaultTaskConfiguration;
import com.atlassian.bamboo.plugins.confdeploy.config.RemoteProductType;
import com.atlassian.bamboo.plugins.confdeploy.config.TaskConfiguration;
import com.atlassian.bamboo.plugins.confdeploy.config.TaskConfigurationFactory;
import com.atlassian.fugue.Either;
import java.io.File;
import org.apache.commons.lang.StringUtils;

public class DefaultTaskConfigurationFactory
implements TaskConfigurationFactory {
    private static final String DEFAULT_ATLASSIAN_ID_BASE_URL = "https://id.atlassian.com";
    private final ArtifactRetriever artifactRetriever;

    public DefaultTaskConfigurationFactory(ArtifactRetriever artifactRetriever) {
        this.artifactRetriever = artifactRetriever;
    }

    @Override
    public Either<TaskConfiguration, Failure> getTaskConfiguration(ConfigurationMap map) {
        Either<File, Failure> maybePluginJar;
        boolean branchEnabled = map.getAsBoolean("deployBranchEnabled");
        boolean allowCertificateErrors = map.getAsBoolean("certificateCheckDisabled");
        boolean enableTrafficLogging = map.getAsBoolean("enableTrafficLogging");
        Object maybePluginInstallationTimeout = map.get((Object)"pluginInstallationTimeout");
        int pluginInstallationTimeout = maybePluginInstallationTimeout == null ? 90 : Integer.valueOf(maybePluginInstallationTimeout.toString());
        String remoteBaseUrl = (String)map.get((Object)"confDeployURL");
        String username = (String)map.get((Object)"confDeployUsername");
        String password = "";
        boolean useAtlassianId = map.getAsBoolean("useAtlassianId");
        boolean useAtlassianIdWebSudo = false;
        String atlassianIdBaseUrl = "";
        String atlassianIdUsername = "";
        String atlassianIdPassword = "";
        String atlassianIdAppName = "";
        if (useAtlassianId) {
            useAtlassianIdWebSudo = map.getAsBoolean("useAtlassianIdWebSudo");
            atlassianIdAppName = (String)map.get((Object)"atlassianIdAppName");
            atlassianIdBaseUrl = map.containsKey((Object)"atlassianIdBaseURL") ? (String)map.get((Object)"atlassianIdBaseURL") : DEFAULT_ATLASSIAN_ID_BASE_URL;
            atlassianIdUsername = (String)map.get((Object)"atlassianIdUsername");
            atlassianIdPassword = DefaultTaskConfigurationFactory.getPassword((String)map.get((Object)"atlassianIdPassword"), (String)map.get((Object)"atlassianIdKey"), (String)map.get((Object)"atlassianIdPasswordVariable"));
        }
        if (!useAtlassianId || !useAtlassianIdWebSudo) {
            password = DefaultTaskConfigurationFactory.getPassword((String)map.get((Object)"confDeployPassword"), (String)map.get((Object)"confDeployKey"), (String)map.get((Object)"confDeployPasswordVariable"));
        }
        if ((maybePluginJar = this.artifactRetriever.getFileFromArtifact((String)map.get((Object)"confDeployJar"))).isRight()) {
            return Either.right((Object)maybePluginJar.right().get());
        }
        String productKey = (String)map.get((Object)"bcpd.config.productType");
        RemoteProductType productType = null;
        if (StringUtils.isNotBlank((String)productKey)) {
            productType = RemoteProductType.fromKey(productKey);
        }
        return Either.left((Object)new DefaultTaskConfiguration(productType, (File)maybePluginJar.left().get(), remoteBaseUrl, username, password, useAtlassianId, useAtlassianIdWebSudo, atlassianIdUsername, atlassianIdPassword, atlassianIdBaseUrl, atlassianIdAppName, allowCertificateErrors, branchEnabled, enableTrafficLogging, pluginInstallationTimeout));
    }

    private static String getPassword(String encryptedPassword, String decryptionKey, String passwordVariable) {
        return StringUtils.isBlank((String)passwordVariable) ? Crypto.decrypt(decryptionKey, encryptedPassword) : passwordVariable;
    }
}

