/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.confdeploy.config;

import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionContext;
import com.atlassian.bamboo.plugins.artifact.RequestedArtifacts;
import com.atlassian.bamboo.plugins.confdeploy.AvailableArtifact;
import com.atlassian.bamboo.plugins.confdeploy.config.ArtifactRetriever;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.runtime.RuntimeTaskDefinition;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.FileVisitor;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutor;
import com.atlassian.fugue.Iterables;
import com.atlassian.fugue.Option;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseArtifactRetriever
implements ArtifactRetriever {
    private static final Logger log = LoggerFactory.getLogger(BaseArtifactRetriever.class);
    protected final CustomVariableContext variableContext;
    protected final CommonTaskContext taskContext;

    protected BaseArtifactRetriever(CommonTaskContext taskContext, CustomVariableContext variableContext) {
        this.taskContext = taskContext;
        this.variableContext = variableContext;
    }

    protected File getArtifactFromTransferTask(AvailableArtifact artifact) {
        long artifactDownloaderTaskId = (Long)Preconditions.checkNotNull((Object)artifact.getArtifactDownloaderTaskId());
        int artifactDownloaderTransferId = (Integer)Preconditions.checkNotNull((Object)artifact.getArtifactDownloaderTransferId());
        Option maybeTaskDefinition = Iterables.findFirst((Iterable)this.taskContext.getCommonContext().getRuntimeTaskDefinitions(), taskDefinition -> taskDefinition.getId() == artifactDownloaderTaskId);
        if (maybeTaskDefinition.isEmpty()) {
            return null;
        }
        RuntimeTaskDefinition artifactDownloaderTaskDefinition = (RuntimeTaskDefinition)maybeTaskDefinition.get();
        Map artDownloaderRuntimeData = (Map)Preconditions.checkNotNull((Object)artifactDownloaderTaskDefinition.getRuntimeData(), (Object)"Artifact Provider Task has no runtime data");
        RequestedArtifacts requestedArtifacts = (RequestedArtifacts)artDownloaderRuntimeData.get("artifactContexts");
        List downloadRequests = requestedArtifacts.getRequestsForKeyIndex(artifactDownloaderTransferId);
        if (CollectionUtils.isEmpty((Collection)downloadRequests)) {
            return null;
        }
        RequestedArtifacts.Request firstRequest = (RequestedArtifacts.Request)downloadRequests.get(0);
        List filePatterns = firstRequest.getContext().getCopyPatterns();
        VariableSubstitutor variableSubstitutor = this.variableContext.getVariableSubstitutorFactory().newSubstitutorForCommonContext(this.taskContext.getCommonContext());
        List<String> evaledFilePatterns = filePatterns.stream().map(s -> (String)this.variableContext.withVariableSubstitutor(variableSubstitutor, () -> this.variableContext.substituteString(s))).collect(Collectors.toList());
        String localPath = firstRequest.getLocalPath();
        return BaseArtifactRetriever.getFileByAntPath(evaledFilePatterns, new File(this.taskContext.getWorkingDirectory(), localPath));
    }

    protected File getArtifactFromJob(AvailableArtifact artifactDesc) {
        TaskContext to = (TaskContext)Narrow.to((Object)this.taskContext, TaskContext.class);
        if (to == null) {
            String msg = "Could not retrieve artifact " + artifactDesc.toString() + " from parent job's artifact subscription since this is a deployment task, which does not understand the concept of artifact subscriptions.";
            log.error(msg);
            return null;
        }
        for (ArtifactSubscriptionContext artifactSubscriptionContext : to.getBuildContext().getArtifactContext().getSubscriptionContexts()) {
            if (artifactSubscriptionContext.getArtifactDefinitionContext().getId() != artifactDesc.getArtifactId().longValue()) continue;
            return new File(artifactSubscriptionContext.getEffectiveDestinationPath());
        }
        return null;
    }

    private static File getFileByAntPath(List<String> filePatterns, File localPath) {
        final ArrayList rawArtifacts = new ArrayList();
        FileVisitor namesVisitor = new FileVisitor(localPath){

            public void visitFile(File file) throws InterruptedException {
                rawArtifacts.add(file);
            }
        };
        for (String filePattern : filePatterns) {
            try {
                namesVisitor.visitFilesThatMatch(filePattern);
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        return rawArtifacts.isEmpty() ? null : (File)rawArtifacts.get(0);
    }
}

