/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.confdeploy;

import com.atlassian.fugue.Pair;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;

public class Crypto {
    private static final String ALGORITHM = "AES";

    public static String decrypt(String key, String encrypted) {
        SecretKeySpec keySpec = new SecretKeySpec(Base64.decodeBase64((String)key), ALGORITHM);
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(2, keySpec);
            return new String(cipher.doFinal(Base64.decodeBase64((String)encrypted)));
        }
        catch (InvalidKeyException e) {
            String msg = String.format("Unable to decrypt value: %s", e.getMessage());
            throw new RuntimeException(msg, e);
        }
        catch (NoSuchAlgorithmException e) {
            String msg = String.format("Unable to decrypt value: %s", e.getMessage());
            throw new RuntimeException(msg, e);
        }
        catch (NoSuchPaddingException e) {
            String msg = String.format("Unable to decrypt value: %s", e.getMessage());
            throw new RuntimeException(msg, e);
        }
        catch (IllegalBlockSizeException e) {
            String msg = String.format("Unable to decrypt value: %s", e.getMessage());
            throw new RuntimeException(msg, e);
        }
        catch (BadPaddingException e) {
            String msg = String.format("Unable to decrypt value: %s", e.getMessage());
            throw new RuntimeException(msg, e);
        }
    }

    public static Pair<String, String> encrypt(String value) {
        Cipher cipher;
        if (StringUtils.isBlank((String)value)) {
            throw new RuntimeException("Cannot encrypt an empty value");
        }
        String key = Crypto.generateKey();
        SecretKeySpec keySpec = new SecretKeySpec(Base64.decodeBase64((String)key), ALGORITHM);
        try {
            cipher = Cipher.getInstance(ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
        try {
            cipher.init(1, keySpec);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
        try {
            String encrypted = Base64.encodeBase64String((byte[])cipher.doFinal(value.getBytes()));
            return new Pair((Object)key, (Object)encrypted);
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException(e);
        }
        catch (BadPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String generateKey() {
        KeyGenerator keyGenerator;
        try {
            keyGenerator = KeyGenerator.getInstance(ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            String msg = String.format("Unable to create KeyGenerator for %s algorithm: %s", ALGORITHM, e.getMessage());
            throw new RuntimeException(msg, e);
        }
        keyGenerator.init(128);
        SecretKey key = keyGenerator.generateKey();
        return Base64.encodeBase64String((byte[])key.getEncoded());
    }
}

