/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.confdeploy;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.deployments.execution.DeploymentTaskContext;
import com.atlassian.bamboo.deployments.execution.DeploymentTaskType;
import com.atlassian.bamboo.plugins.confdeploy.Failure;
import com.atlassian.bamboo.plugins.confdeploy.Result;
import com.atlassian.bamboo.plugins.confdeploy.config.DefaultTaskConfigurationFactory;
import com.atlassian.bamboo.plugins.confdeploy.config.DeploymentArtifactRetriever;
import com.atlassian.bamboo.plugins.confdeploy.config.JobArtifactRetriever;
import com.atlassian.bamboo.plugins.confdeploy.config.RemoteProductType;
import com.atlassian.bamboo.plugins.confdeploy.config.TaskConfiguration;
import com.atlassian.bamboo.plugins.confdeploy.upload.DefaultUploadClient;
import com.atlassian.bamboo.plugins.confdeploy.upload.DefaultUploadClientFactory;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.fugue.Either;
import com.atlassian.tunnel.utils.IOUtils;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public abstract class AutoDeployTask
implements TaskType,
DeploymentTaskType {
    public static final int DEFAULT_PLUGIN_INSTALLATION_TIMEOUT = 90;
    private CustomVariableContext variableContext;

    public abstract RemoteProductType getProductType(TaskConfiguration var1);

    @NotNull
    public TaskResult execute(@NotNull TaskContext taskContext) throws TaskException {
        BuildLogger buildLogger = taskContext.getBuildLogger();
        JobArtifactRetriever artifactRetriever = new JobArtifactRetriever(taskContext, this.variableContext);
        DefaultTaskConfigurationFactory taskConfigurationFactory = new DefaultTaskConfigurationFactory(artifactRetriever);
        Either<TaskConfiguration, Failure> maybeConfig = taskConfigurationFactory.getTaskConfiguration(taskContext.getConfigurationMap());
        if (maybeConfig.isRight()) {
            Result failure = (Result)maybeConfig.right().get();
            buildLogger.addBuildLogEntry(failure.getMessage());
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failed().build();
        }
        TaskConfiguration config = (TaskConfiguration)maybeConfig.left().get();
        BuildContext buildContext = taskContext.getBuildContext();
        if (!config.allowBranchBuildExecution() && buildContext.isBranch()) {
            buildLogger.addBuildLogEntry("Plugin deployment task has been disabled for branch builds.");
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).success().build();
        }
        return this.run((CommonTaskContext)taskContext, config, buildLogger);
    }

    @NotNull
    public TaskResult execute(@NotNull DeploymentTaskContext deploymentContext) throws TaskException {
        BuildLogger buildLogger = deploymentContext.getBuildLogger();
        DeploymentArtifactRetriever artifactRetriever = new DeploymentArtifactRetriever(deploymentContext, this.variableContext);
        DefaultTaskConfigurationFactory taskConfigurationFactory = new DefaultTaskConfigurationFactory(artifactRetriever);
        Either<TaskConfiguration, Failure> maybeConfig = taskConfigurationFactory.getTaskConfiguration(deploymentContext.getConfigurationMap());
        if (maybeConfig.isRight()) {
            Result failure = (Result)maybeConfig.right().get();
            buildLogger.addBuildLogEntry(failure.getMessage());
            return TaskResultBuilder.newBuilder((CommonTaskContext)deploymentContext).failed().build();
        }
        return this.run((CommonTaskContext)deploymentContext, (TaskConfiguration)maybeConfig.left().get(), buildLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskResult run(CommonTaskContext context, TaskConfiguration config, BuildLogger buildLogger) throws TaskException {
        InputStream pomProperties;
        block7: {
            Deprecated annotation = this.getClass().getAnnotation(Deprecated.class);
            if (annotation != null) {
                buildLogger.addErrorLogEntry("This task is deprecated and will be removed in a future version of this plugin. You should edit your task configuration and replace this task with the new 'Deploy Plugin' task.");
            }
            pomProperties = null;
            try {
                pomProperties = this.getClass().getClassLoader().getResourceAsStream("META-INF/maven/com.atlassian.bamboo.plugins.deploy/continuous-plugin-deployment/pom.properties");
                Properties mavenProperties = new Properties();
                mavenProperties.load(pomProperties);
                Object versionObj = mavenProperties.get("version");
                if (versionObj == null) {
                    buildLogger.addBuildLogEntry("Starting plugin deployment task (version unknown - is this a custom build??");
                    break block7;
                }
                buildLogger.addBuildLogEntry("Starting plugin deployment task (v. " + versionObj.toString() + ")");
            }
            catch (Exception e) {
                try {
                    buildLogger.addBuildLogEntry("Starting plugin deployment task (failed to load version: " + e.getMessage() + ")");
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(pomProperties);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)pomProperties);
            }
        }
        IOUtils.closeQuietly((Closeable)pomProperties);
        buildLogger.addBuildLogEntry(String.format("Deploying %s to %s at %s", new Object[]{config.getPluginJar().getName(), this.getProductType(config), config.getRemoteBaseUrl()}));
        DefaultUploadClientFactory uploadClientFactory = new DefaultUploadClientFactory();
        DefaultUploadClient uploadClient = uploadClientFactory.getUploadClient(this.getProductType(config), config, buildLogger);
        Result uploadResult = uploadClient.deploy(config);
        buildLogger.addBuildLogEntry(uploadResult.getMessage());
        if (uploadResult.isSuccess()) {
            return TaskResultBuilder.newBuilder((CommonTaskContext)context).success().build();
        }
        return TaskResultBuilder.newBuilder((CommonTaskContext)context).failed().build();
    }

    public void setVariableContext(CustomVariableContext variableContext) {
        this.variableContext = variableContext;
    }
}

