/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.confdeploy.upload.http;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.plugins.confdeploy.config.TaskConfiguration;
import com.atlassian.bamboo.plugins.confdeploy.upload.http.RepeatableHttpEntity;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.StatusLine;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class BuildLoggingResponseInterceptor
implements HttpResponseInterceptor {
    private final BuildLogger buildLogger;
    private final TaskConfiguration taskConfiguration;

    public BuildLoggingResponseInterceptor(BuildLogger buildLogger, TaskConfiguration taskConfiguration) {
        this.buildLogger = buildLogger;
        this.taskConfiguration = taskConfiguration;
    }

    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        this.buildLogger.addBuildLogEntry("**** Incoming Response Debug Log ****");
        StatusLine statusLine = response.getStatusLine();
        this.logWithNoPasswords("< " + statusLine.toString());
        for (Header h : response.getAllHeaders()) {
            this.logWithNoPasswords("< " + h.toString());
        }
        this.buildLogger.addBuildLogEntry("< ");
        Object responseEntity = response.getEntity();
        if (responseEntity != null) {
            if (!responseEntity.isRepeatable()) {
                responseEntity = new RepeatableHttpEntity((HttpEntity)responseEntity);
                response.setEntity(responseEntity);
            }
            this.logWithNoPasswords("< " + EntityUtils.toString((HttpEntity)responseEntity));
        }
        this.buildLogger.addBuildLogEntry("*************************************");
    }

    private void logWithNoPasswords(String logMessage) {
        if (StringUtils.isNotBlank((String)this.taskConfiguration.getPassword()) && logMessage.contains(this.taskConfiguration.getPassword())) {
            logMessage = logMessage.replace(this.taskConfiguration.getPassword(), "******");
        }
        if (StringUtils.isNotBlank((String)this.taskConfiguration.getAtlassianIdPassword()) && logMessage.contains(this.taskConfiguration.getAtlassianIdPassword())) {
            logMessage = logMessage.replace(this.taskConfiguration.getAtlassianIdPassword(), "******");
        }
        this.buildLogger.addBuildLogEntry(logMessage);
    }
}

