/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.confdeploy.upload.http;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.plugins.confdeploy.config.TaskConfiguration;
import com.atlassian.bamboo.plugins.confdeploy.upload.http.RepeatableHttpEntity;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class BuildLoggingRequestInterceptor
implements HttpRequestInterceptor {
    private final BuildLogger buildLogger;
    private final TaskConfiguration taskConfiguration;

    public BuildLoggingRequestInterceptor(BuildLogger buildLogger, TaskConfiguration taskConfiguration) {
        this.buildLogger = buildLogger;
        this.taskConfiguration = taskConfiguration;
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        this.buildLogger.addBuildLogEntry("**** Outgoing Request Debug Log (" + context.getAttribute("http.target_host") + ") ****");
        this.buildLogger.addBuildLogEntry("> " + request.getRequestLine().toString());
        for (Header h : request.getAllHeaders()) {
            this.logWithNoPasswords("> " + h.toString());
        }
        this.buildLogger.addBuildLogEntry("> ");
        if (request instanceof HttpEntityEnclosingRequest) {
            Object requestEntity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (requestEntity == null) {
                this.buildLogger.addBuildLogEntry("> (No Entity found)");
            } else if (requestEntity.getContentType().getValue().startsWith("multipart/form-data")) {
                this.buildLogger.addBuildLogEntry("> (Multi-part Form Entity cannot be shown)");
            } else if (!requestEntity.isRepeatable()) {
                requestEntity = new RepeatableHttpEntity((HttpEntity)requestEntity);
                ((HttpEntityEnclosingRequest)request).setEntity(requestEntity);
                this.logWithNoPasswords("> " + EntityUtils.toString((HttpEntity)requestEntity));
            } else {
                this.logWithNoPasswords("> " + EntityUtils.toString((HttpEntity)requestEntity));
            }
        }
        this.buildLogger.addBuildLogEntry("************************************");
    }

    private void logWithNoPasswords(String logMessage) {
        if (StringUtils.isNotBlank((String)this.taskConfiguration.getPassword()) && logMessage.contains(this.taskConfiguration.getPassword())) {
            logMessage = logMessage.replace(this.taskConfiguration.getPassword(), "******");
        }
        if (StringUtils.isNotBlank((String)this.taskConfiguration.getAtlassianIdPassword()) && logMessage.contains(this.taskConfiguration.getAtlassianIdPassword())) {
            logMessage = logMessage.replace(this.taskConfiguration.getAtlassianIdPassword(), "******");
        }
        this.buildLogger.addBuildLogEntry(logMessage);
    }
}

