/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.confdeploy.upload.behaviour.upm;

import com.atlassian.bamboo.plugins.confdeploy.Failure;
import com.atlassian.bamboo.plugins.confdeploy.Result;
import com.atlassian.bamboo.plugins.confdeploy.Success;
import com.atlassian.bamboo.plugins.confdeploy.UrlUtils;
import com.atlassian.bamboo.plugins.confdeploy.config.TaskConfiguration;
import com.atlassian.bamboo.plugins.confdeploy.upload.behaviour.RequestBehaviour;
import com.atlassian.fugue.Either;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class PluginUploadRequestBehaviour
implements RequestBehaviour {
    @Override
    public Either<HttpUriRequest, Failure> getRequest(TaskConfiguration configuration, Map<String, Object> requestContext) {
        String uploadUrl;
        Validate.notEmpty((String)configuration.getRemoteBaseUrl(), (String)"Remote Base URL is required to upload plugins.");
        Validate.notNull((Object)configuration.getPluginJar(), (String)"An actual plugin artifact is required in order to upload a plugin artifact. Derp.");
        if (!requestContext.containsKey("upmToken")) {
            return Either.right((Object)Result.failure("Could not start plugin upload - the UPM XSRF token is missing (probably a bug!)"));
        }
        String upmToken = requestContext.get("upmToken").toString();
        try {
            uploadUrl = UrlUtils.join(configuration.getRemoteBaseUrl(), "/rest/plugins/1.0/?token=" + URLEncoder.encode(upmToken, "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            return Either.right((Object)Result.failure("Failed to encode UTF-8 String - Java, you suck.", e));
        }
        HttpPost upmPost = new HttpPost(uploadUrl);
        upmPost.addHeader("Accept", "application/json");
        upmPost.setEntity(PluginUploadRequestBehaviour.getPluginUploadEntity(configuration.getPluginJar()));
        return Either.left((Object)upmPost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result handleResponse(HttpResponse response) throws IOException {
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 202) {
                Failure failure = Result.failure("Plugin upload failed. Unexpected HTTP status " + statusCode + " was returned.");
                return failure;
            }
            String entity = EntityUtils.toString((HttpEntity)response.getEntity());
            try {
                Success success = Result.success("Plugin upload succeeded!", new JSONObject(entity));
                return success;
            }
            catch (JSONException e) {
                Failure failure = Result.failure("Failed to JSONify the plugin upload response.", (Exception)((Object)e));
                EntityUtils.consume((HttpEntity)response.getEntity());
                return failure;
            }
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
    }

    private static HttpEntity getPluginUploadEntity(File plugin) {
        FileBody uploadFile = new FileBody(plugin);
        MultipartEntity uploadEntity = new MultipartEntity();
        uploadEntity.addPart("plugin", (ContentBody)uploadFile);
        return uploadEntity;
    }
}

