/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.confdeploy.upload.behaviour.product;

import com.atlassian.bamboo.plugins.confdeploy.Failure;
import com.atlassian.bamboo.plugins.confdeploy.Result;
import com.atlassian.bamboo.plugins.confdeploy.Success;
import com.atlassian.bamboo.plugins.confdeploy.UrlUtils;
import com.atlassian.bamboo.plugins.confdeploy.upload.behaviour.ProductLoginRequestBehaviour;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;

public class StashLoginRequestBehaviour
extends ProductLoginRequestBehaviour {
    public StashLoginRequestBehaviour(String baseUrl) {
        super(UrlUtils.join(baseUrl, "/j_atl_security_check"), "j_username", "j_password");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result handleResponse(HttpResponse response) throws IOException {
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 302) {
                Failure failure = Result.failure("Product login failed. HTTP Status code " + statusCode + " was returned.");
                return failure;
            }
            Header location = response.getFirstHeader("Location");
            if (location.getValue().endsWith("/login")) {
                Failure failure = Result.failure("Product login failed. We got redirected back to the login screen again");
                return failure;
            }
            Success success = Result.success("Product login success!");
            return success;
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
    }
}

