/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.confdeploy.upload.behaviour.product;

import com.atlassian.bamboo.plugins.confdeploy.Failure;
import com.atlassian.bamboo.plugins.confdeploy.Result;
import com.atlassian.bamboo.plugins.confdeploy.Success;
import com.atlassian.bamboo.plugins.confdeploy.UrlUtils;
import com.atlassian.bamboo.plugins.confdeploy.config.TaskConfiguration;
import com.atlassian.bamboo.plugins.confdeploy.upload.behaviour.RequestBehaviour;
import com.atlassian.fugue.Either;
import java.io.IOException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class JiraPermissionCheckBehaviour
implements RequestBehaviour {
    @Override
    public Either<HttpUriRequest, Failure> getRequest(TaskConfiguration configuration, Map<String, Object> requestContext) {
        String url = UrlUtils.join(configuration.getRemoteBaseUrl(), "/rest/api/2/mypermissions");
        return Either.left((Object)new HttpGet(url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result handleResponse(HttpResponse response) throws IOException {
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                Failure failure = Result.failure("Unexpected HTTP Status code " + statusCode + " was returned.");
                return failure;
            }
            String entity = EntityUtils.toString((HttpEntity)response.getEntity());
            try {
                JSONObject myPermissions = new JSONObject(entity);
                JSONObject permissions = myPermissions.getJSONObject("permissions");
                JSONObject SYSTEM_ADMIN = permissions.getJSONObject("SYSTEM_ADMIN");
                boolean hasPermission = SYSTEM_ADMIN.getBoolean("havePermission");
                if (!hasPermission) {
                    Failure failure = Result.failure("The user configured for this task does not have system administration privileges on the target JIRA server.");
                    return failure;
                }
            }
            catch (JSONException e) {
                Failure failure = Result.failure("Failed to JSONify the permission check response.", (Exception)((Object)e));
                return failure;
            }
            Success success = Result.success("Permission check successful!");
            return success;
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
    }
}

