/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.confdeploy.upload.behaviour.product;

import com.atlassian.bamboo.plugins.confdeploy.Failure;
import com.atlassian.bamboo.plugins.confdeploy.Result;
import com.atlassian.bamboo.plugins.confdeploy.Success;
import com.atlassian.bamboo.plugins.confdeploy.UrlUtils;
import com.atlassian.bamboo.plugins.confdeploy.upload.behaviour.ProductLoginRequestBehaviour;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;

public class FeCruLoginRequestBehaviour
extends ProductLoginRequestBehaviour {
    public FeCruLoginRequestBehaviour(String baseUrl) {
        super(UrlUtils.join(baseUrl, "/login"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result handleResponse(HttpResponse response) throws IOException {
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                String username = response.getFirstHeader("X-AUSERNAME").getValue();
                if (username.equals("anonymous")) {
                    Failure failure = Result.failure("Product login failed - response username was anonymous");
                    return failure;
                }
            } else if (statusCode != 302) {
                Failure failure = Result.failure("Product login failed. HTTP Status code " + statusCode + " was returned.");
                return failure;
            }
            Success success = Result.success("Product login success!");
            return success;
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
    }
}

