/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.confdeploy.upload.behaviour;

import com.atlassian.bamboo.plugins.confdeploy.Failure;
import com.atlassian.bamboo.plugins.confdeploy.Result;
import com.atlassian.bamboo.plugins.confdeploy.Success;
import com.atlassian.bamboo.plugins.confdeploy.config.TaskConfiguration;
import com.atlassian.bamboo.plugins.confdeploy.upload.behaviour.RequestBehaviour;
import com.atlassian.fugue.Either;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public abstract class ProductLoginRequestBehaviour
implements RequestBehaviour {
    private final boolean useQueryParams;
    private final String loginUrl;
    private final String usernameParameterName;
    private final String passwordParameterName;

    public ProductLoginRequestBehaviour(String loginUrl) {
        this.loginUrl = loginUrl;
        this.useQueryParams = false;
        this.usernameParameterName = null;
        this.passwordParameterName = null;
    }

    public ProductLoginRequestBehaviour(String loginUrl, String usernameParameterName, String passwordParameterName) {
        this.loginUrl = loginUrl;
        this.useQueryParams = true;
        this.usernameParameterName = usernameParameterName;
        this.passwordParameterName = passwordParameterName;
    }

    @Override
    public Either<HttpUriRequest, Failure> getRequest(TaskConfiguration configuration, Map<String, Object> requestContext) {
        Validate.notEmpty((String)configuration.getUsername(), (String)"Username must be specified for login to succeed.");
        Validate.notEmpty((String)configuration.getPassword(), (String)"Password must be specified for login to succeed.");
        HttpPost loginRequest = new HttpPost(this.loginUrl);
        loginRequest.addHeader("X-Atlassian-Token", "no-check");
        if (this.useQueryParams) {
            UrlEncodedFormEntity entity;
            try {
                entity = new UrlEncodedFormEntity((List)Lists.newArrayList((Object[])new NameValuePair[]{new BasicNameValuePair(this.usernameParameterName, configuration.getUsername()), new BasicNameValuePair(this.passwordParameterName, configuration.getPassword())}));
            }
            catch (UnsupportedEncodingException e) {
                return Either.right((Object)Result.failure("Failed to encode UTF8 String  Java, you suck.", e));
            }
            loginRequest.setEntity((HttpEntity)entity);
        } else {
            String passwordString = configuration.getUsername() + ":" + configuration.getPassword();
            String basicAuthHeader = Base64.getEncoder().encodeToString(passwordString.getBytes());
            loginRequest.addHeader("Authorization", "Basic " + basicAuthHeader);
        }
        return Either.left((Object)loginRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result handleResponse(HttpResponse response) throws IOException {
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200 && statusCode != 302) {
                Failure failure = Result.failure("Product login failed. HTTP Status code " + statusCode + " was returned.");
                return failure;
            }
            Header[] headers = response.getHeaders("X-Seraph-LoginReason");
            if (headers == null || headers.length == 0) {
                Failure failure = Result.failure("Product login failed.  The 'X-Seraph-LoginReason' header was missing from the response.");
                return failure;
            }
            Optional ok = Iterables.tryFind(Arrays.asList(headers), (Predicate)new Predicate<Header>(){

                public boolean apply(Header header) {
                    return header.getValue().equals("OK");
                }
            });
            if (!ok.isPresent()) {
                Failure failure = Result.failure("Product login failed. The X-Seraph-LoginReason response was " + headers[0].getValue() + ".");
                return failure;
            }
            Success success = Result.success("Product login success!");
            return success;
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
    }
}

