/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.confdeploy.upload;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.plugins.confdeploy.Failure;
import com.atlassian.bamboo.plugins.confdeploy.Result;
import com.atlassian.bamboo.plugins.confdeploy.config.TaskConfiguration;
import com.atlassian.bamboo.plugins.confdeploy.upload.UploadClient;
import com.atlassian.bamboo.plugins.confdeploy.upload.behaviour.PollingRequestBehaviour;
import com.atlassian.bamboo.plugins.confdeploy.upload.behaviour.RequestBehaviour;
import com.atlassian.bamboo.plugins.confdeploy.upload.http.HttpClientWrapper;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.fugue.Either;
import com.atlassian.util.concurrent.Nullable;
import com.atlassian.util.concurrent.Timeout;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.methods.HttpUriRequest;
import org.json.JSONObject;

class DefaultUploadClient
implements UploadClient {
    private final RequestBehaviour loginStrategy;
    @Nullable
    private final RequestBehaviour permissionCheckStrategy;
    @Nullable
    private final RequestBehaviour webSudoStrategy;
    private final RequestBehaviour upmTokenStrategy;
    private final RequestBehaviour pluginUploadStrategy;
    private final PollingRequestBehaviour uploadSuccessCheckStrategy;
    @Nullable
    private final RequestBehaviour upmSelfUpdateStrategy;
    @Nullable
    private final PollingRequestBehaviour upmSelfUpdateCheckStrategy;
    private final HttpClientWrapper client;
    private final BuildLogger buildLogger;

    DefaultUploadClient(RequestBehaviour loginStrategy, @Nullable RequestBehaviour permissionCheckStrategy, @Nullable RequestBehaviour webSudoStrategy, RequestBehaviour upmTokenStrategy, RequestBehaviour pluginUploadStrategy, PollingRequestBehaviour uploadSuccessCheckStrategy, @Nullable RequestBehaviour upmSelfUpdateStrategy, @Nullable PollingRequestBehaviour upmSelfUpdateCheckStrategy, BuildLogger buildLogger, HttpClientWrapper client) {
        this.loginStrategy = loginStrategy;
        this.permissionCheckStrategy = permissionCheckStrategy;
        this.webSudoStrategy = webSudoStrategy;
        this.upmTokenStrategy = upmTokenStrategy;
        this.pluginUploadStrategy = pluginUploadStrategy;
        this.uploadSuccessCheckStrategy = uploadSuccessCheckStrategy;
        this.upmSelfUpdateStrategy = upmSelfUpdateStrategy;
        this.upmSelfUpdateCheckStrategy = upmSelfUpdateCheckStrategy;
        this.buildLogger = buildLogger;
        this.client = client;
    }

    @Override
    public Result deploy(TaskConfiguration taskConfiguration) throws TaskException {
        Result webSudoResult;
        Result permissionCheckResult;
        HashMap<String, Object> requestContext = new HashMap<String, Object>();
        Result loginResult = this.executeRequest(this.loginStrategy, taskConfiguration, requestContext);
        if (!loginResult.isSuccess()) {
            return loginResult;
        }
        if (this.permissionCheckStrategy != null && !(permissionCheckResult = this.executeRequest(this.permissionCheckStrategy, taskConfiguration, requestContext)).isSuccess()) {
            return permissionCheckResult;
        }
        if (this.webSudoStrategy != null && !(webSudoResult = this.executeRequest(this.webSudoStrategy, taskConfiguration, requestContext)).isSuccess()) {
            return webSudoResult;
        }
        Result getTokenResult = this.executeRequest(this.upmTokenStrategy, taskConfiguration, requestContext);
        if (!getTokenResult.isSuccess()) {
            return getTokenResult;
        }
        String upmToken = (String)getTokenResult.getContext();
        requestContext.put("upmToken", upmToken);
        Result uploadResult = this.executeRequest(this.pluginUploadStrategy, taskConfiguration, requestContext);
        if (!uploadResult.isSuccess()) {
            return uploadResult;
        }
        JSONObject uploadResponse = (JSONObject)uploadResult.getContext();
        requestContext.put("responseEntity", uploadResponse);
        Result pollResult = this.executePollingRequest(this.uploadSuccessCheckStrategy, taskConfiguration, requestContext, Timeout.getMillisTimeout((long)taskConfiguration.getPluginInstallationTimeout(), (TimeUnit)TimeUnit.SECONDS));
        if (!pollResult.isSuccess()) {
            return pollResult;
        }
        if (this.upmSelfUpdateStrategy != null && this.upmSelfUpdateCheckStrategy != null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new TaskException("Error while waiting to trigger UPM self-update", (Throwable)e);
            }
            this.buildLogger.addBuildLogEntry(String.format("Contacting %s to trigger UPM self-update.", taskConfiguration.getRemoteBaseUrl()));
            Result triggerSelfUpdateResult = this.executeRequest(this.upmSelfUpdateStrategy, taskConfiguration, requestContext);
            if (!triggerSelfUpdateResult.isSuccess()) {
                return triggerSelfUpdateResult;
            }
            Result selfUpdateResult = this.executePollingRequest(this.upmSelfUpdateCheckStrategy, taskConfiguration, requestContext, Timeout.getMillisTimeout((long)taskConfiguration.getPluginInstallationTimeout(), (TimeUnit)TimeUnit.SECONDS));
            if (!selfUpdateResult.isSuccess()) {
                return selfUpdateResult;
            }
        }
        return Result.success("Plugin upload completed successfully. Nice going, mate!");
    }

    private Result executePollingRequest(PollingRequestBehaviour requestBehaviour, TaskConfiguration taskConfiguration, Map<String, Object> requestContext, Timeout timeout) {
        Result pollOutcome;
        Either<HttpUriRequest, Failure> maybeRequest = requestBehaviour.getRequest(taskConfiguration, requestContext);
        if (maybeRequest.isRight()) {
            Failure failure = (Failure)maybeRequest.right().get();
            this.buildLogger.addErrorLogEntry(failure.getMessage(), failure.getContext() instanceof Exception ? (Exception)failure.getContext() : null);
        }
        if (!(pollOutcome = this.client.poll((HttpUriRequest)maybeRequest.left().get(), requestBehaviour, timeout)).isSuccess()) {
            this.buildLogger.addErrorLogEntry(pollOutcome.getMessage(), pollOutcome.getContext() instanceof Exception ? (Exception)pollOutcome.getContext() : null);
        } else {
            this.buildLogger.addBuildLogEntry(pollOutcome.getMessage());
        }
        return pollOutcome;
    }

    private Result executeRequest(RequestBehaviour requestBehaviour, TaskConfiguration taskConfiguration, Map<String, Object> requestContext) {
        Result responseOutcome;
        Either<HttpUriRequest, Failure> maybeRequest = requestBehaviour.getRequest(taskConfiguration, requestContext);
        if (maybeRequest.isRight()) {
            Failure failure = (Failure)maybeRequest.right().get();
            this.buildLogger.addErrorLogEntry(failure.getMessage(), failure.getContext() instanceof Exception ? (Exception)failure.getContext() : null);
        }
        if (!(responseOutcome = this.client.execute((HttpUriRequest)maybeRequest.left().get(), requestBehaviour)).isSuccess()) {
            this.buildLogger.addErrorLogEntry(responseOutcome.getMessage(), responseOutcome.getContext() instanceof Exception ? (Exception)responseOutcome.getContext() : null);
        } else {
            this.buildLogger.addBuildLogEntry(responseOutcome.getMessage());
        }
        return responseOutcome;
    }

    public RequestBehaviour getLoginStrategy() {
        return this.loginStrategy;
    }

    public RequestBehaviour getWebSudoStrategy() {
        return this.webSudoStrategy;
    }

    public RequestBehaviour getUpmTokenStrategy() {
        return this.upmTokenStrategy;
    }

    public RequestBehaviour getPluginUploadStrategy() {
        return this.pluginUploadStrategy;
    }

    public PollingRequestBehaviour getUploadSuccessCheckStrategy() {
        return this.uploadSuccessCheckStrategy;
    }

    public RequestBehaviour getUpmSelfUpdateStrategy() {
        return this.upmSelfUpdateStrategy;
    }

    public PollingRequestBehaviour getUpmSelfUpdateCheckStrategy() {
        return this.upmSelfUpdateCheckStrategy;
    }
}

