/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.confdeploy.config.ui;

import com.atlassian.bamboo.deployments.DeploymentTaskContextHelper;
import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinition;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionManager;
import com.atlassian.bamboo.plan.artifact.ImmutableArtifactSubscription;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plugin.ArtifactDownloaderTaskConfigurationHelper;
import com.atlassian.bamboo.plugins.confdeploy.AvailableArtifact;
import com.atlassian.bamboo.plugins.confdeploy.config.ui.ArtifactSubscriber;
import com.atlassian.bamboo.plugins.confdeploy.config.ui.SubscribedArtifact;
import com.atlassian.bamboo.task.TaskContextHelper;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.user.BambooAuthenticationContext;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.util.concurrent.NotNull;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DefaultArtifactSubscriber
implements ArtifactSubscriber {
    private static final long ALL_ARTIFACTS_ID = -1L;
    private final ArtifactDefinitionManager artifactDefinitionManager;
    private final CachedPlanManager cachedPlanManager;
    private final BambooAuthenticationContext bambooAuthenticationContext;

    public DefaultArtifactSubscriber(ArtifactDefinitionManager artifactDefinitionManager, CachedPlanManager cachedPlanManager, BambooAuthenticationContext bambooAuthenticationContext) {
        this.artifactDefinitionManager = artifactDefinitionManager;
        this.cachedPlanManager = cachedPlanManager;
        this.bambooAuthenticationContext = bambooAuthenticationContext;
    }

    @Override
    public Iterable<SubscribedArtifact> getSubscriptions(Map<String, Object> taskContext) {
        if (TaskContextHelper.isDeploymentMode(taskContext)) {
            Environment environment = DeploymentTaskContextHelper.getEnvironment(taskContext);
            assert (environment != null);
            return this.getDownloadedArtifacts(environment.getTaskDefinitions());
        }
        ImmutableJob job = (ImmutableJob)Narrow.downTo((Object)TaskContextHelper.getPlan(taskContext), ImmutableJob.class);
        assert (job != null);
        return Iterables.concat(this.getSubscriptionsFromJob(job), this.getDownloadedArtifacts(job.getBuildDefinition().getTaskDefinitions()));
    }

    private Iterable<SubscribedArtifact> getSubscriptionsFromJob(@NotNull ImmutableJob job) {
        return Iterables.transform((Iterable)job.getArtifactSubscriptions(), (Function)new Function<ImmutableArtifactSubscription, SubscribedArtifact>(){

            public SubscribedArtifact apply(ImmutableArtifactSubscription subscription) {
                return new SubscribedArtifact(AvailableArtifact.from(subscription).toString(), DefaultArtifactSubscriber.this.bambooAuthenticationContext.getI18NBean().getText("bcpd.config.form.artifact.subscription.artifacts"), subscription.getName());
            }
        });
    }

    private Iterable<SubscribedArtifact> getDownloadedArtifacts(@NotNull List<TaskDefinition> taskDefinitions) {
        ArrayList<SubscribedArtifact> artifacts = new ArrayList<SubscribedArtifact>();
        Iterable downloadTasks = Iterables.filter(taskDefinitions, (Predicate)new Predicate<TaskDefinition>(){

            public boolean apply(TaskDefinition task) {
                return task.getPluginKey().equals("com.atlassian.bamboo.plugins.bamboo-artifact-downloader-plugin:artifactdownloadertask") && task.isEnabled();
            }
        });
        for (TaskDefinition task : downloadTasks) {
            Map taskConfiguration = task.getConfiguration();
            String groupName = this.getGroupName(taskConfiguration);
            for (String artifactKey : ArtifactDownloaderTaskConfigurationHelper.getArtifactKeys((Map)taskConfiguration)) {
                ArtifactDefinition artifactDefinition;
                boolean isAllArtifacts;
                long artifactId = Long.valueOf((String)taskConfiguration.get(artifactKey));
                int transferId = ArtifactDownloaderTaskConfigurationHelper.getIndexFromKey((String)artifactKey);
                boolean bl = isAllArtifacts = artifactId == -1L;
                if (isAllArtifacts) {
                    String sourcePlanKey = (String)ArtifactDownloaderTaskConfigurationHelper.getSourcePlanKey((Map)taskConfiguration);
                    ImmutablePlan sourcePlan = this.cachedPlanManager.getPlanByKey(PlanKeys.getPlanKey((String)sourcePlanKey));
                    ImmutableChain chain = (ImmutableChain)Narrow.to((Object)sourcePlan, ImmutableChain.class);
                    List sharedArtifactsByChain = this.artifactDefinitionManager.findSharedArtifactsByChain(chain);
                    for (ArtifactDefinition d : sharedArtifactsByChain) {
                        artifacts.add(new SubscribedArtifact(AvailableArtifact.fromTransferTask(d.getId(), task, transferId, d.getName()).toString(), groupName, this.getArtifactName(d)));
                    }
                    continue;
                }
                if (!taskConfiguration.containsKey(artifactKey) || (artifactDefinition = this.artifactDefinitionManager.findArtifactDefinition(artifactId)) == null) continue;
                artifacts.add(new SubscribedArtifact(AvailableArtifact.fromTransferTask(artifactDefinition.getId(), task, transferId, artifactDefinition.getName()).toString(), groupName, this.getArtifactName(artifactDefinition)));
            }
        }
        return artifacts;
    }

    private String getGroupName(Map<String, String> taskConfiguration) {
        String sourcePlanKey = (String)ArtifactDownloaderTaskConfigurationHelper.getSourcePlanKey(taskConfiguration);
        ImmutablePlan plan = this.cachedPlanManager.getPlanByKey(PlanKeys.getPlanKey((String)sourcePlanKey));
        return this.bambooAuthenticationContext.getI18NBean().getText("bcpd.config.form.artifact.plan.artifacts", (Object[])new String[]{plan.getName()});
    }

    private String getArtifactName(ArtifactDefinition artifact) {
        return this.bambooAuthenticationContext.getI18NBean().getText("bcpd.config.form.artifact.plan.one.artifact", (Object[])new String[]{artifact.getProducerJob().getKey(), artifact.getName()});
    }
}

