/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.confdeploy.config;

import com.atlassian.bamboo.deployments.execution.DeploymentTaskContext;
import com.atlassian.bamboo.plugin.ArtifactDownloaderTaskConfigurationHelper;
import com.atlassian.bamboo.plugins.confdeploy.AvailableArtifact;
import com.atlassian.bamboo.plugins.confdeploy.Failure;
import com.atlassian.bamboo.plugins.confdeploy.Result;
import com.atlassian.bamboo.plugins.confdeploy.config.ArtifactRetriever;
import com.atlassian.bamboo.plugins.confdeploy.config.BaseArtifactRetriever;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.runtime.RuntimeTaskDefinition;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Iterables;
import com.atlassian.fugue.Option;
import java.io.File;
import java.util.List;
import java.util.Map;

public class DeploymentArtifactRetriever
extends BaseArtifactRetriever
implements ArtifactRetriever {
    public DeploymentArtifactRetriever(DeploymentTaskContext taskContext, CustomVariableContext customVariableContext) {
        super((CommonTaskContext)taskContext, customVariableContext);
    }

    @Override
    public Either<File, Failure> getFileFromArtifact(String artifactString) {
        AvailableArtifact artifact;
        if (!AvailableArtifact.isValidStoredArtifact(artifactString)) {
            Either<AvailableArtifact, Failure> artifactResult = this.tryToRetieveArtifactByName(artifactString);
            if (artifactResult.isRight()) {
                return Either.right((Object)artifactResult.right().get());
            }
            artifact = (AvailableArtifact)artifactResult.left().get();
        } else {
            artifact = new AvailableArtifact(artifactString);
        }
        if (!artifact.isFromTransferTask()) {
            return Either.right((Object)Result.failure("Configured plugin artifact was not acquired by a transfer task, but this is a deployment project. WTF?"));
        }
        File pluginJar = this.getArtifactFromTransferTask(artifact);
        if (pluginJar == null) {
            String msg = String.format("Unable to find the artifact with id %d in this task's context. Has an artifact subscription been configured for that artifact in this job?", artifact.getArtifactId());
            return Either.right((Object)Result.failure(msg));
        }
        if (!pluginJar.exists() || !pluginJar.isFile()) {
            String msg = String.format("Artifact file %s is either missing or not a file.", pluginJar.getAbsolutePath());
            return Either.right((Object)Result.failure(msg));
        }
        return Either.left((Object)pluginJar);
    }

    private Either<AvailableArtifact, Failure> tryToRetieveArtifactByName(String artifactName) {
        Option<RuntimeTaskDefinition> artifactDownloaderTaskOptional = this.getArtifactDownloaderTask();
        if (!artifactDownloaderTaskOptional.isDefined()) {
            return Either.right((Object)Result.failure("Found no artifact downloader task for this deployment."));
        }
        RuntimeTaskDefinition taskDefinition = (RuntimeTaskDefinition)artifactDownloaderTaskOptional.get();
        long artifactId = Long.parseLong((String)taskDefinition.getConfiguration().get(ArtifactDownloaderTaskConfigurationHelper.getArtifactIdKey((int)0)));
        Iterable artifactKeys = ArtifactDownloaderTaskConfigurationHelper.getArtifactKeys((Map)taskDefinition.getConfiguration());
        Option artifactKey = Iterables.first((Iterable)artifactKeys);
        if (!artifactKey.isDefined()) {
            String msg = String.format("Could not find artifact for name %s", artifactName);
            return Either.right((Object)Result.failure(msg));
        }
        int transferId = ArtifactDownloaderTaskConfigurationHelper.getIndexFromKey((String)((String)artifactKey.get()));
        return Either.left((Object)AvailableArtifact.fromTransferTask(artifactId, (TaskDefinition)taskDefinition, transferId, artifactName));
    }

    private Option<RuntimeTaskDefinition> getArtifactDownloaderTask() {
        List runtimeTaskDefinitions = this.taskContext.getCommonContext().getRuntimeTaskDefinitions();
        return Iterables.findFirst((Iterable)runtimeTaskDefinitions, task -> task.getPluginKey().equals("com.atlassian.bamboo.plugins.bamboo-artifact-downloader-plugin:artifactdownloadertask"));
    }
}

