/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.confdeploy;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionManager;
import com.atlassian.bamboo.plugins.confdeploy.AvailableArtifact;
import com.atlassian.bamboo.plugins.confdeploy.config.RemoteProductType;
import com.atlassian.bamboo.plugins.confdeploy.config.ui.ArtifactSubscriber;
import com.atlassian.bamboo.plugins.confdeploy.config.ui.ConfigurationSerializer;
import com.atlassian.bamboo.plugins.confdeploy.config.ui.DefaultConfigurationValidator;
import com.atlassian.bamboo.plugins.confdeploy.config.ui.SubscribedArtifact;
import com.atlassian.bamboo.plugins.confdeploy.config.ui.TaskParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.i18n.I18nBean;
import com.atlassian.bamboo.utils.i18n.I18nBeanFactory;
import com.atlassian.bamboo.webwork.util.WwSelectOption;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.opensymphony.xwork.ActionContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AutoDeployConfigurator
extends AbstractTaskConfigurator
implements TaskConfigurator {
    private static final Logger log = LoggerFactory.getLogger(AutoDeployConfigurator.class);
    private ArtifactSubscriber artifactSubscriber;
    private ConfigurationSerializer configurationSerializer;
    private WebResourceManager webResourceManager;
    private ArtifactDefinitionManager artifactDefinitionManager;
    private I18nBeanFactory i18nBeanFactory;

    protected abstract RemoteProductType getProduct();

    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        return this.configurationSerializer.serializeTaskContext(new TaskParametersMap(params), previousTaskDefinition);
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        List<WwSelectOption> artifacts = this.addArtifactData(context);
        if (artifacts.size() > 0) {
            context.put("bcpd_config_artifact", artifacts.get(0));
        }
        context.put("bcpd_config_branching", String.valueOf(false));
        context.put("bcpd_config_useAtlassianId", String.valueOf(false));
        context.put("bcpd_config_useAtlassianIdWebSudo", String.valueOf(false));
        context.put("bcpd_config_ssl", String.valueOf(false));
        context.put("bcpd_config_logging", String.valueOf(false));
        String webResources = this.webResourceManager.getResourceTags("com.atlassian.bamboo.plugins.deploy.continuous-plugin-deployment:taskResources", UrlMode.RELATIVE);
        context.put("webResources", webResources);
        context.put("product", (Object)this.getProduct());
        context.put("state", "create");
        context.put("multiProduct", false);
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        Object useAtlassianId;
        this.configurationSerializer.deserializeTaskContext(context, taskDefinition);
        this.addArtifactData(context);
        String webResources = this.webResourceManager.getResourceTags("com.atlassian.bamboo.plugins.deploy.continuous-plugin-deployment:taskResources", UrlMode.RELATIVE);
        context.put("webResources", webResources);
        context.put("state", "edit");
        context.put("multiProduct", false);
        context.put("product", (Object)this.getProduct());
        if (context.containsKey("bcpd_config_artifact") && context.get("bcpd_config_artifact") != null && AvailableArtifact.isValidStoredArtifact(context.get("bcpd_config_artifact").toString())) {
            context.put("bcpd_config_artifact_name", new AvailableArtifact(context.get("bcpd_config_artifact").toString()).getName());
        }
        if ((useAtlassianId = context.get("bcpd_config_useAtlassianId")) != null && Boolean.valueOf(useAtlassianId.toString()).booleanValue()) {
            context.put("storedUser", Lists.newArrayList((Object[])new Object[]{context.get("bcpd_config_atlassianIdUsername")}));
        } else {
            context.put("storedUser", Lists.newArrayList((Object[])new Object[]{context.get("bcpd_config_username")}));
        }
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        new DefaultConfigurationValidator(this.getI18nBeanForActionLocale(), this.artifactDefinitionManager).validate(new TaskParametersMap(params), errorCollection);
    }

    private List<WwSelectOption> addArtifactData(Map<String, Object> context) {
        Iterable<SubscribedArtifact> subscriptions = this.artifactSubscriber.getSubscriptions(context);
        ArrayList artifacts = Lists.newArrayList((Iterable)Iterables.transform(subscriptions, (Function)new Function<SubscribedArtifact, WwSelectOption>(){

            public WwSelectOption apply(SubscribedArtifact subscribedArtifact) {
                return new WwSelectOption(subscribedArtifact.getDisplayName(), subscribedArtifact.getGroup(), subscribedArtifact.getId());
            }
        }));
        context.put("artifacts", artifacts);
        return artifacts;
    }

    protected I18nBean getI18nBeanForActionLocale() {
        Locale locale = ActionContext.getContext().getLocale();
        return this.i18nBeanFactory.getI18nBean(locale);
    }

    public void setArtifactSubscriber(ArtifactSubscriber artifactSubscriber) {
        this.artifactSubscriber = artifactSubscriber;
    }

    public void setConfigurationSerializer(ConfigurationSerializer configurationSerializer) {
        this.configurationSerializer = configurationSerializer;
    }

    public void setWebResourceManager(WebResourceManager webResourceManager) {
        this.webResourceManager = webResourceManager;
    }

    public void setArtifactDefinitionManager(ArtifactDefinitionManager artifactDefinitionManager) {
        this.artifactDefinitionManager = artifactDefinitionManager;
    }

    public void setI18nBeanFactory(I18nBeanFactory i18nBeanFactory) {
        this.i18nBeanFactory = i18nBeanFactory;
    }
}

