/* global AJS, BAMBOO */
var bambooAnnCookie = "bambooAnnouncement";
var bambooAnnIdPrefix = "announcementBanner-";

(function () {
    var announcementUrl = BAMBOO.contextPath + "/rest/announcement/1.0/announcement";
    AJS.$.get(
        announcementUrl,
        function (data) {
            if (data.announcement !== "" || data.announcementTitle !== "") {
                var cookie = Cookies.get(bambooAnnCookie);
                if (data.announcementMD5 !== cookie) {
                    AJS.$(document).ready(function () {
                        AJS.messages.warning("#header > .notifications", {
                            title: data.announcementTitle,
                            body: data.announcement,
                            closeable: true,
                            id: bambooAnnIdPrefix + data.announcementMD5,
                        });
                    });
                }
            }
        },
        "json",
    );
})();

AJS.$(document).ready(function () {
    AJS.$(document).on("aui-message-close", function (e, a) {
        var id = a.attr("id");
        if (id.indexOf(bambooAnnIdPrefix) === 0) {
            var val = id.substring(bambooAnnIdPrefix.length);
            Cookies.set(bambooAnnCookie, val); // no expiry means session cookie , { expires: 7 });
        }
    });
});
