/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.announcement;

import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.plugins.announcement.AnnouncementModel;
import com.atlassian.bamboo.plugins.announcement.AnnouncementService;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;

public class DefaultAnnouncementService
implements AnnouncementService {
    private static final Logger log = Logger.getLogger(DefaultAnnouncementService.class);
    private static final String ANNOUNCEMENT_KEY = "com.atlassian.bamboo.plugins.announcement.announcement";
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final AnnouncementModel EMPTY_ANNOUNCEMENT = new AnnouncementModel("", "");
    private final BandanaManager bandanaManager;
    private AtomicReference<AnnouncementModel> announcement = new AtomicReference();

    public DefaultAnnouncementService(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
        Object announcementObject = bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, ANNOUNCEMENT_KEY);
        if (announcementObject != null) {
            try {
                AnnouncementModel announcementModel = (AnnouncementModel)mapper.readValue((String)announcementObject, AnnouncementModel.class);
                this.announcement.set(announcementModel);
            }
            catch (JsonProcessingException e) {
                log.error((Object)"JSON processing error occurred when trying to deserialise announcement, resetting to empty", (Throwable)e);
                this.announcement.set(EMPTY_ANNOUNCEMENT);
            }
            catch (IOException e) {
                log.error((Object)"IO error occurred when trying to deserialise announcement, resetting to empty", (Throwable)e);
                this.announcement.set(EMPTY_ANNOUNCEMENT);
            }
        } else {
            this.announcement.set(EMPTY_ANNOUNCEMENT);
        }
    }

    @Override
    public AnnouncementModel getAnnouncement() {
        return this.announcement.get();
    }

    @Override
    public void setAnnouncement(AnnouncementModel announcement) {
        try {
            AnnouncementModel announcementToSave = announcement == null ? EMPTY_ANNOUNCEMENT : announcement;
            String serialisedAnnouncement = mapper.writeValueAsString((Object)announcementToSave);
            this.bandanaManager.setValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, ANNOUNCEMENT_KEY, (Object)serialisedAnnouncement);
            this.announcement.set(announcementToSave);
        }
        catch (JsonProcessingException e) {
            log.error((Object)"JSON processing error occurred when trying to deserialise announcement, resetting to empty", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"IO error occurred when trying to deserialise announcement, resetting to empty", (Throwable)e);
        }
    }
}

