/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.announcement;

import com.atlassian.bamboo.plugins.announcement.AnnouncementModel;
import com.atlassian.bamboo.plugins.announcement.AnnouncementService;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.user.BambooAuthenticationContext;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.concurrent.ExecutionException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@Path(value="/announcement")
public class AnnouncementResource {
    private final AnnouncementService announcementService;
    private final BambooPermissionManager permissionManager;
    private final BambooAuthenticationContext bambooAuthenticationContext;

    public AnnouncementResource(AnnouncementService announcementService, BambooPermissionManager permissionManager, BambooAuthenticationContext bambooAuthenticationContext) {
        this.announcementService = announcementService;
        this.permissionManager = permissionManager;
        this.bambooAuthenticationContext = bambooAuthenticationContext;
    }

    @POST
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response setAnnouncement(AnnouncementModel announcement) throws ExecutionException {
        String userName = this.bambooAuthenticationContext.getUserName();
        if (!StringUtils.isBlank((String)userName) && this.permissionManager.isAdmin(userName)) {
            this.announcementService.setAnnouncement(announcement);
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"You must be an administrator to set an announcement.").build();
    }

    @GET
    @AnonymousAllowed
    @Produces(value={"application/json", "application/xml"})
    public Response getAnnouncement() throws ExecutionException {
        AnnouncementModel announcement = this.announcementService.getAnnouncement();
        return Response.ok((Object)announcement).build();
    }
}

