/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.announcement;

import com.atlassian.bamboo.plugins.announcement.AnnouncementModel;
import com.atlassian.bamboo.plugins.announcement.AnnouncementService;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.user.BambooAuthenticationContext;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.user.User;

public class AnnouncementConfiguration
extends BambooActionSupport {
    private static final int MAX_ANNOUNCEMENT_LENGTH = 1000;
    private final AnnouncementService announcementService;
    private final BambooAuthenticationContext bambooAuthenticationContext;
    private final BambooPermissionManager bambooPermissionManager;
    private String announcement;
    private String announcementTitle;

    public AnnouncementConfiguration(AnnouncementService announcementService, BambooAuthenticationContext bambooAuthenticationContext, BambooPermissionManager bambooPermissionManager) {
        this.announcementService = announcementService;
        this.bambooAuthenticationContext = bambooAuthenticationContext;
        this.bambooPermissionManager = bambooPermissionManager;
    }

    public String execute() throws Exception {
        if (this.checkAdmin()) {
            return super.doExecute();
        }
        return "error";
    }

    public String edit() {
        if (!this.checkAdmin()) {
            this.addActionError("You must be an administrator to set an announcement.");
            return "error";
        }
        if (this.announcement == null || this.announcementTitle == null) {
            return "success";
        }
        if (this.announcement.length() > 1000 || this.announcementTitle.length() > 1000) {
            this.addActionError("Announcement length cannot exceed 1000  chars");
            return "error";
        }
        this.announcementService.setAnnouncement(new AnnouncementModel(this.announcement.trim(), this.announcementTitle.trim()));
        return "success";
    }

    public String getAnnouncement() {
        return this.announcementService.getAnnouncement().getAnnouncement();
    }

    public String getAnnouncementTitle() {
        return this.announcementService.getAnnouncement().getAnnouncementTitle();
    }

    public void setAnnouncement(String announcement) {
        this.announcement = announcement;
    }

    public void setAnnouncementTitle(String announcementTitle) {
        this.announcementTitle = announcementTitle;
    }

    private boolean checkAdmin() {
        User user = this.bambooAuthenticationContext.getUser();
        return user != null && this.bambooPermissionManager.isAdmin(user.getName());
    }
}

