/*
 * Decompiled with CFR 0.152.
 */
package com.jezhumble.javasysmon;

import com.jezhumble.javasysmon.ParseException;
import com.jezhumble.javasysmon.ProcessInfo;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class LinuxProcessInfoParser {
    private final String stat;
    private final String status;
    private final String cmdline;
    private final HashMap uids;
    private final int userHz;
    private static final Pattern STATUS_NAME_MATCHER = Pattern.compile("Name:\\s+(\\w+)", 8);
    private static final Pattern STATUS_UID_MATCHER = Pattern.compile("Uid:\\s+(\\d+)\\s.*", 8);
    private static final Pattern STATUS_VM_SIZE_MATCHER = Pattern.compile("VmSize:\\s+(\\d+) kB", 8);
    private static final Pattern STATUS_VM_RSS_MATCHER = Pattern.compile("VmRSS:\\s+(\\d+) kB", 8);

    public LinuxProcessInfoParser(String stat, String status, String cmdline, HashMap uids, int userHz) {
        this.stat = stat;
        this.status = status;
        this.cmdline = cmdline;
        this.uids = uids;
        this.userHz = userHz;
    }

    public ProcessInfo parse() throws ParseException {
        long totalBytes;
        long residentBytes;
        long systemMillis;
        long userMillis;
        int parentPid;
        int pid;
        int openParen = this.stat.indexOf("(");
        int closeParen = this.stat.lastIndexOf(")");
        if (openParen <= 1 || closeParen < 0 || closeParen > this.stat.length() - 2) {
            throw new ParseException("Stat '" + this.stat + "' does not include expected parens around process name");
        }
        String[] statElements = this.stat.substring(closeParen + 2).split(" ");
        if (statElements.length < 13) {
            throw new ParseException("Stat '" + this.stat + "' contains fewer elements than expected");
        }
        String pidStr = this.stat.substring(0, openParen - 1);
        try {
            pid = Integer.parseInt(pidStr);
            parentPid = Integer.parseInt(statElements[1]);
            userMillis = Long.parseLong(statElements[11]) * (long)(1000 / this.userHz);
            systemMillis = Long.parseLong(statElements[12]) * (long)(1000 / this.userHz);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Unable to parse stat '" + this.stat + "'");
        }
        try {
            residentBytes = Long.parseLong(this.getFirstMatch(STATUS_VM_RSS_MATCHER, this.status)) * 1024L;
            totalBytes = Long.parseLong(this.getFirstMatch(STATUS_VM_SIZE_MATCHER, this.status)) * 1024L;
        }
        catch (NumberFormatException e) {
            throw new ParseException("Unable to extract memory usage information from status '" + this.status + "'");
        }
        return new ProcessInfo(pid, parentPid, this.trim(this.cmdline), this.getFirstMatch(STATUS_NAME_MATCHER, this.status), (String)this.uids.get(this.getFirstMatch(STATUS_UID_MATCHER, this.status)), userMillis, systemMillis, residentBytes, totalBytes);
    }

    private String trim(String cmdline) {
        return cmdline.replace('\u0000', ' ').replace('\n', ' ');
    }

    public String getFirstMatch(Pattern pattern, String string) {
        try {
            Matcher matcher = pattern.matcher(string);
            matcher.find();
            return matcher.group(1);
        }
        catch (Exception e) {
            return "0";
        }
    }
}

