/*
 * Decompiled with CFR 0.152.
 */
package com.jezhumble.javasysmon;

import com.jezhumble.javasysmon.CpuTimes;
import com.jezhumble.javasysmon.FileUtils;
import com.jezhumble.javasysmon.JavaSysMon;
import com.jezhumble.javasysmon.LinuxProcessInfoParser;
import com.jezhumble.javasysmon.MemoryStats;
import com.jezhumble.javasysmon.Monitor;
import com.jezhumble.javasysmon.ParseException;
import com.jezhumble.javasysmon.ProcessInfo;
import com.jezhumble.javasysmon.UnixPasswdParser;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class LinuxMonitor
implements Monitor {
    private static final Logger LOG = Logger.getLogger(LinuxMonitor.class.getName());
    private static final Pattern TOTAL_MEMORY_PATTERN = Pattern.compile("MemTotal:\\s+(\\d+) kB", 8);
    private static final Pattern FREE_MEMORY_PATTERN = Pattern.compile("MemFree:\\s+(\\d+) kB", 8);
    private static final Pattern TOTAL_SWAP_PATTERN = Pattern.compile("SwapTotal:\\s+(\\d+) kB", 8);
    private static final Pattern FREE_SWAP_PATTERN = Pattern.compile("SwapFree:\\s+(\\d+) kB", 8);
    private static final Pattern CPU_JIFFIES_PATTERN = Pattern.compile("cpu\\s+(.*)", 8);
    private static final Pattern NUM_CPU_PATTERN = Pattern.compile("processor\\s+:\\s+(\\d+)", 8);
    private static final Pattern CPU_FREQ_PATTERN = Pattern.compile("model name[^@]*@\\s+([0-9.A-Za-z]*)", 8);
    private static final Pattern UPTIME_PATTERN = Pattern.compile("([\\d]*).*");
    private static final Pattern PID_PATTERN = Pattern.compile("([\\d]*).*");
    private static final Pattern DISTRIBUTION = Pattern.compile("DISTRIB_DESCRIPTION=\"(.*)\"", 8);
    private FileUtils fileUtils;
    private int userHz = 100;

    LinuxMonitor(FileUtils fileUtils) {
        this.fileUtils = fileUtils;
    }

    public LinuxMonitor() {
        this.fileUtils = new FileUtils();
        JavaSysMon.addSupportedConfig("Linux (only tested with x86)");
        if (System.getProperty("os.name").toLowerCase().startsWith("linux")) {
            JavaSysMon.setMonitor(this);
            JavaSysMon.addSupportedConfig("Linux (only tested with x86)");
        }
    }

    @Override
    public String osName() {
        String distribution = this.fileUtils.runRegexOnFile(DISTRIBUTION, "/etc/lsb-release");
        if (null == distribution) {
            return System.getProperty("os.name");
        }
        return distribution;
    }

    @Override
    public MemoryStats physical() {
        String totalMemory = this.fileUtils.runRegexOnFile(TOTAL_MEMORY_PATTERN, "/proc/meminfo");
        long total = Long.parseLong(totalMemory) * 1024L;
        String freeMemory = this.fileUtils.runRegexOnFile(FREE_MEMORY_PATTERN, "/proc/meminfo");
        long free = Long.parseLong(freeMemory) * 1024L;
        return new MemoryStats(free, total);
    }

    @Override
    public MemoryStats swap() {
        String totalMemory = this.fileUtils.runRegexOnFile(TOTAL_SWAP_PATTERN, "/proc/meminfo");
        long total = Long.parseLong(totalMemory) * 1024L;
        String freeMemory = this.fileUtils.runRegexOnFile(FREE_SWAP_PATTERN, "/proc/meminfo");
        long free = Long.parseLong(freeMemory) * 1024L;
        return new MemoryStats(free, total);
    }

    @Override
    public int numCpus() {
        int numCpus = 0;
        try {
            String cpuInfo = this.fileUtils.slurp("/proc/cpuinfo");
            Matcher matcher = NUM_CPU_PATTERN.matcher(cpuInfo);
            while (matcher.find()) {
                ++numCpus;
            }
            return numCpus;
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    @Override
    public long cpuFrequencyInHz() {
        String cpuFrequencyAsString = this.fileUtils.runRegexOnFile(CPU_FREQ_PATTERN, "/proc/cpuinfo");
        int strLen = cpuFrequencyAsString.length();
        BigDecimal cpuFrequency = new BigDecimal(cpuFrequencyAsString.substring(0, strLen - 3));
        long multiplier = this.getMultiplier(cpuFrequencyAsString.charAt(strLen - 3));
        return cpuFrequency.multiply(new BigDecimal(Long.toString(multiplier))).longValue();
    }

    @Override
    public long uptimeInSeconds() {
        String uptime = this.fileUtils.runRegexOnFile(UPTIME_PATTERN, "/proc/uptime");
        return Long.parseLong(uptime);
    }

    @Override
    public int currentPid() {
        String pid = this.fileUtils.runRegexOnFile(PID_PATTERN, "/proc/self/stat");
        return Integer.parseInt(pid);
    }

    @Override
    public ProcessInfo[] processTable() {
        ArrayList<ProcessInfo> processTable = new ArrayList<ProcessInfo>();
        String[] pids = this.fileUtils.pidsFromProcFilesystem();
        for (int i = 0; i < pids.length; ++i) {
            try {
                String stat = this.fileUtils.slurp("/proc/" + pids[i] + "/stat");
                String status = this.fileUtils.slurp("/proc/" + pids[i] + "/status");
                String cmdline = this.fileUtils.slurp("/proc/" + pids[i] + "/cmdline");
                UnixPasswdParser passwdParser = new UnixPasswdParser();
                LinuxProcessInfoParser parser = new LinuxProcessInfoParser(stat, status, cmdline, passwdParser.parse(), this.userHz);
                processTable.add(parser.parse());
                continue;
            }
            catch (ParseException pe) {
                LOG.log(Level.WARNING, pe.getMessage(), pe);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return processTable.toArray(new ProcessInfo[processTable.size()]);
    }

    @Override
    public CpuTimes cpuTimes() {
        String[] parsedJiffies = this.fileUtils.runRegexOnFile(CPU_JIFFIES_PATTERN, "/proc/stat").split("\\s+");
        long userJiffies = Long.parseLong(parsedJiffies[0]) + Long.parseLong(parsedJiffies[1]);
        long idleJiffies = Long.parseLong(parsedJiffies[3]);
        long systemJiffies = Long.parseLong(parsedJiffies[2]);
        if (parsedJiffies.length > 4) {
            for (int i = 4; i < parsedJiffies.length; ++i) {
                systemJiffies += Long.parseLong(parsedJiffies[i]);
            }
        }
        return new CpuTimes(this.toMillis(userJiffies), this.toMillis(systemJiffies), this.toMillis(idleJiffies));
    }

    @Override
    public void killProcess(int pid) {
        try {
            Runtime runtime = Runtime.getRuntime();
            runtime.exec("kill -TERM " + pid);
            File processFile = new File("/proc/" + pid);
            for (int i = 0; i < 6; ++i) {
                Thread.sleep(TimeUnit.SECONDS.toMillis(10L));
                if (processFile.exists()) continue;
                return;
            }
            runtime.exec("kill -KILL " + pid);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not kill process id " + pid, e);
        }
    }

    private long getMultiplier(char multiplier) {
        switch (multiplier) {
            case 'G': {
                return 1000000000L;
            }
            case 'M': {
                return 1000000L;
            }
            case 'k': {
                return 1000L;
            }
        }
        return 0L;
    }

    private long toMillis(long jiffies) {
        int multiplier = 1000 / this.userHz;
        return jiffies * (long)multiplier;
    }
}

