/*
 * Decompiled with CFR 0.152.
 */
package com.jezhumble.javasysmon;

import com.jezhumble.javasysmon.CpuTimes;
import com.jezhumble.javasysmon.LinuxMonitor;
import com.jezhumble.javasysmon.MacOsXMonitor;
import com.jezhumble.javasysmon.MemoryStats;
import com.jezhumble.javasysmon.Monitor;
import com.jezhumble.javasysmon.NullMonitor;
import com.jezhumble.javasysmon.OsProcess;
import com.jezhumble.javasysmon.ProcessInfo;
import com.jezhumble.javasysmon.ProcessVisitor;
import com.jezhumble.javasysmon.SolarisMonitor;
import com.jezhumble.javasysmon.WindowsMonitor;
import java.util.ArrayList;

public class JavaSysMon
implements Monitor {
    private static Monitor monitor = null;
    private static ArrayList supported = new ArrayList();

    public static void setMonitor(Monitor myMonitor) {
        if (monitor == null || monitor instanceof NullMonitor) {
            monitor = myMonitor;
        }
    }

    static void addSupportedConfig(String config) {
        supported.add(config);
    }

    public static void main(String[] params) throws Exception {
        if (monitor instanceof NullMonitor) {
            System.err.println("Couldn't find an implementation for OS: " + System.getProperty("os.name"));
            System.err.println("Supported configurations:");
            for (String config : supported) {
                System.err.println(config);
            }
        } else {
            if (params.length == 1) {
                System.out.println("Attempting to kill process id " + params[0]);
                monitor.killProcess(Integer.parseInt(params[0]));
            }
            CpuTimes initialTimes = monitor.cpuTimes();
            System.out.println("OS name: " + monitor.osName() + "  Uptime: " + JavaSysMon.secsInDaysAndHours(monitor.uptimeInSeconds()) + "  Current PID: " + monitor.currentPid());
            System.out.println("Number of CPUs: " + monitor.numCpus() + "  CPU frequency: " + monitor.cpuFrequencyInHz() / 1000000L + " MHz");
            System.out.println("RAM " + monitor.physical() + "  SWAP " + monitor.swap());
            System.out.println("Sampling CPU usage...");
            Thread.sleep(500L);
            System.out.println("CPU Usage: " + monitor.cpuTimes().getCpuUsage(initialTimes));
            System.out.println("\n" + ProcessInfo.header());
            ProcessInfo[] processes = monitor.processTable();
            for (int i = 0; i < processes.length; ++i) {
                System.out.println(processes[i].toString());
            }
        }
    }

    public boolean supportedPlatform() {
        return !(monitor instanceof NullMonitor);
    }

    private static String secsInDaysAndHours(long seconds) {
        long days = seconds / 86400L;
        long hours = seconds / 3600L - days * 24L;
        return days + " days " + hours + " hours";
    }

    @Override
    public String osName() {
        return monitor.osName();
    }

    @Override
    public int numCpus() {
        return monitor.numCpus();
    }

    @Override
    public long cpuFrequencyInHz() {
        return monitor.cpuFrequencyInHz();
    }

    @Override
    public long uptimeInSeconds() {
        return monitor.uptimeInSeconds();
    }

    @Override
    public int currentPid() {
        return monitor.currentPid();
    }

    @Override
    public CpuTimes cpuTimes() {
        return monitor.cpuTimes();
    }

    @Override
    public MemoryStats physical() {
        return monitor.physical();
    }

    @Override
    public MemoryStats swap() {
        return monitor.swap();
    }

    @Override
    public ProcessInfo[] processTable() {
        return monitor.processTable();
    }

    public OsProcess processTree() {
        return OsProcess.createTree(monitor.processTable());
    }

    @Override
    public void killProcess(int pid) {
        monitor.killProcess(pid);
    }

    public void visitProcessTree(int pid, ProcessVisitor processVisitor) {
        OsProcess process = this.processTree().find(pid);
        if (process != null) {
            process.accept(processVisitor, 0);
        }
    }

    public void killProcessTree(final int pid, final boolean descendantsOnly) {
        this.visitProcessTree(pid, new ProcessVisitor(){

            @Override
            public boolean visit(OsProcess process, int level) {
                return !descendantsOnly || pid != process.processInfo().getPid();
            }
        });
    }

    public void infanticide() {
        this.killProcessTree(this.currentPid(), true);
    }

    static {
        new MacOsXMonitor();
        new LinuxMonitor();
        new WindowsMonitor();
        new SolarisMonitor();
        new NullMonitor();
    }
}

