/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.predator.executor;

import com.atlassian.bamboo.chains.StageExecution;
import com.atlassian.bamboo.chains.plugins.PreJobAction;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.plugin.module.BambooImmutablePluginModule;
import com.atlassian.bamboo.plugin.predator.PredatorPluginService;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

@BambooImmutablePluginModule
public class PredatorPreJobAction
implements PreJobAction {
    private final PredatorPluginService predatorPluginService;
    private final CachedPlanManager cachedPlanManager;

    @Inject
    public PredatorPreJobAction(PredatorPluginService predatorPluginService, CachedPlanManager cachedPlanManager) {
        this.predatorPluginService = (PredatorPluginService)Preconditions.checkNotNull((Object)predatorPluginService);
        this.cachedPlanManager = (CachedPlanManager)Preconditions.checkNotNull((Object)cachedPlanManager);
    }

    public void execute(@NotNull StageExecution stageExecution, @NotNull BuildContext buildContext) {
        Map customConfiguration = buildContext.getBuildDefinition().getCustomConfiguration();
        customConfiguration.put("custom.agents", this.predatorPluginService.getAgentsRegex());
        customConfiguration.put("custom.skipDocker", this.predatorPluginService.getSkipDocker().toString());
        customConfiguration.put("custom.fail", this.predatorPluginService.getFailBuild().toString());
        customConfiguration.put("custom.processes", this.predatorPluginService.getProcessesToKillRegex());
        customConfiguration.put("custom.commands", this.predatorPluginService.getCommandsToRun());
        customConfiguration.put("custom.delete.workingdir", this.predatorPluginService.getRemoveBuildWorkingDir().toString());
        customConfiguration.put("custom.keep.workingdir.activebranches", this.predatorPluginService.getKeepBuildWorkingDirActiveBranches().toString());
        customConfiguration.put("custom.delete.snapshot", this.predatorPluginService.getDeleteSnapshotsMaven().toString());
        customConfiguration.put("custom.delete.stable", this.predatorPluginService.getDeleteStableMaven().toString());
        customConfiguration.put("custom.delete.stable.age", this.predatorPluginService.getAgeDaysStableToDelete().toString());
        customConfiguration.put("custom.delete.stable.free", this.predatorPluginService.getMinimumFreeDiskGB().toString());
        customConfiguration.put("custom.delete.files", this.predatorPluginService.getDeleteFiles());
        if (this.predatorPluginService.getKeepBuildWorkingDirActiveBranches().booleanValue()) {
            customConfiguration.put("custom.keep.workingdir.activebranches.list", StringUtils.join((Object[])this.getActivePlanKeys(), (String)" "));
        }
    }

    private String[] getActivePlanKeys() {
        ArrayList<String> activePlanKeys = new ArrayList<String>();
        List plans = this.cachedPlanManager.getPlans();
        for (ImmutableTopLevelPlan plan : plans) {
            activePlanKeys.add(plan.getPlanKey().toString());
            activePlanKeys.addAll(this.cachedPlanManager.getBranchesOfChain(plan.getPlanKey()).filter(branch -> !branch.isSuspendedFromBuilding()).map(branch -> branch.getPlanKey().toString()).collect(Collectors.toList()));
        }
        return activePlanKeys.toArray(new String[0]);
    }
}

