/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.predator.executor;

import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.CustomPreBuildAction;
import com.atlassian.bamboo.build.fileserver.BuildDirectoryManager;
import com.atlassian.bamboo.plugin.predator.executor.ComponentUtils;
import com.atlassian.bamboo.plugin.predator.executor.PredatorExecutor;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.agent.capability.AgentContext;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import java.io.File;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class PredatorPreBuildAction
implements CustomPreBuildAction {
    private static final Logger log = Logger.getLogger(PredatorPreBuildAction.class);
    private BuildContext buildContext;
    private BuildLoggerManager buildLoggerManager;
    private BuildDirectoryManager buildDirectoryManager;
    private AgentContext agentContext;
    private String agentsRegex;
    private String deleteFiles;
    private boolean skipDocker;
    private boolean failBuild;
    private String processesToKillRegex;
    private String commandsToRun;
    private File mavenLocalRepoDirectory;
    private boolean removeBuildWorkingDir;
    private boolean keepBuildWorkingDirActiveBranches;
    private boolean deleteSnapshotsMaven;
    private boolean deleteStableMaven;
    private Float ageStableToDelete;
    private Float minimumFreeDisk;
    private File agentWorkingDir;
    private String jobKey;
    private boolean disabled;
    private String[] activePlanKeys;

    public ErrorCollection validate(BuildConfiguration buildConfiguration) {
        return null;
    }

    public void init(@NotNull BuildContext buildContext) {
        log.setLevel(Level.ALL);
        this.buildContext = buildContext;
        this.jobKey = this.buildContext.getPlanKey();
        this.buildLoggerManager = ComponentUtils.getComponentIfNull(this.buildLoggerManager, "buildLoggerManager");
        Map customConfiguration = this.buildContext.getBuildDefinition().getCustomConfiguration();
        this.skipDocker = Boolean.parseBoolean(this.getCustomVariable(customConfiguration, "skipDocker"));
        if (this.skipDocker && this.isRunningInDocker()) {
            return;
        }
        this.agentContext = ComponentUtils.getComponentIfNull(this.agentContext, "agentContext");
        this.agentWorkingDir = new File(this.buildDirectoryManager.getWorkingDirectoryOfCurrentAgent().getAbsolutePath());
        this.mavenLocalRepoDirectory = new File(FileUtils.getUserDirectory(), "/.m2/repository/");
        this.agentsRegex = (String)customConfiguration.get("custom.agents");
        this.failBuild = Boolean.parseBoolean(this.getCustomVariable(customConfiguration, "fail"));
        this.processesToKillRegex = this.getCustomVariable(customConfiguration, "processes");
        this.commandsToRun = this.getCustomVariable(customConfiguration, "commands");
        this.removeBuildWorkingDir = Boolean.parseBoolean(this.getCustomVariable(customConfiguration, "delete.workingdir"));
        this.keepBuildWorkingDirActiveBranches = Boolean.parseBoolean(this.getCustomVariable(customConfiguration, "keep.workingdir.activebranches"));
        this.deleteSnapshotsMaven = Boolean.parseBoolean(this.getCustomVariable(customConfiguration, "delete.snapshot"));
        this.deleteStableMaven = Boolean.parseBoolean(this.getCustomVariable(customConfiguration, "delete.stable"));
        this.ageStableToDelete = Float.valueOf(Float.parseFloat(this.getCustomVariable(customConfiguration, "delete.stable.age")));
        this.minimumFreeDisk = Float.valueOf(Float.parseFloat(this.getCustomVariable(customConfiguration, "delete.stable.free")));
        this.deleteFiles = this.getCustomVariable(customConfiguration, "delete.files");
        if (this.keepBuildWorkingDirActiveBranches) {
            this.activePlanKeys = StringUtils.split((String)this.getCustomVariable(customConfiguration, "keep.workingdir.activebranches.list"));
        }
        this.disabled = Boolean.parseBoolean((String)this.buildContext.getParentBuildContext().getBuildDefinition().getCustomConfiguration().get("custom.predator.disable"));
    }

    private String getCustomVariable(Map<String, String> customConfiguration, String key) {
        return customConfiguration.get("custom." + key);
    }

    @NotNull
    public BuildContext call() {
        PredatorExecutor predatorExecutor = new PredatorExecutor(this.buildLoggerManager.getLogger(this.buildContext.getResultKey()));
        predatorExecutor.logOutput("Starting predator plugin, pre build agent cleaner");
        if (this.skipDocker && this.isRunningInDocker()) {
            predatorExecutor.logOutput("Running in Docker, not running predator");
            return this.buildContext;
        }
        if (this.disabled) {
            predatorExecutor.logOutput("Agent cleaning has been disabled for this plan, skipping");
            return this.buildContext;
        }
        String agentName = this.agentContext.getBuildAgent().getName();
        if (!predatorExecutor.shouldRunInThisAgent(agentName, this.agentsRegex)) {
            predatorExecutor.logOutput("Skipping agent cleaning as " + agentName + " does not match " + this.agentsRegex);
            return this.buildContext;
        }
        boolean failed = false;
        try {
            predatorExecutor.logOutput(String.format("Running these commands: %s", this.commandsToRun));
            predatorExecutor.runCommands(StringUtils.split((String)this.commandsToRun, (char)';'), this.buildContext.getBuildDefinition().getDockerPipelineConfiguration().isEnabled());
        }
        catch (Exception e) {
            predatorExecutor.logError("Exception when trying to run commands", e);
            failed = true;
        }
        try {
            predatorExecutor.killProcesses(this.processesToKillRegex);
        }
        catch (Exception e) {
            predatorExecutor.logError("Exception when trying to kill processes", e);
            failed = true;
        }
        predatorExecutor.logOutput("Initial free space: " + predatorExecutor.retrieveFreeSpaceGB() + " GB");
        try {
            predatorExecutor.removeOldBuildWorkingDirectory(this.removeBuildWorkingDir, this.keepBuildWorkingDirActiveBranches, this.agentWorkingDir, this.jobKey, this.activePlanKeys);
        }
        catch (Exception e) {
            predatorExecutor.logError("Exception when trying to remove old build working directories", e);
            failed = true;
        }
        try {
            predatorExecutor.removeMavenSnapshots(this.deleteSnapshotsMaven, this.mavenLocalRepoDirectory);
        }
        catch (Exception e) {
            predatorExecutor.logError("Exception when trying to remove snapshots", e);
            failed = true;
        }
        try {
            predatorExecutor.removeEmptyArtifacts(this.mavenLocalRepoDirectory);
        }
        catch (Exception e) {
            predatorExecutor.logError("Exception when trying to delete empty artifacts", e);
            failed = true;
        }
        try {
            predatorExecutor.removeMavenStable(this.deleteStableMaven, this.mavenLocalRepoDirectory, this.ageStableToDelete, this.minimumFreeDisk);
        }
        catch (Exception e) {
            predatorExecutor.logError("Exception when trying to stable artifacts", e);
            failed = true;
        }
        try {
            predatorExecutor.deleteFiles(StringUtils.split((String)this.deleteFiles, (char)','), FileUtils.getUserDirectory(), false);
        }
        catch (Exception e) {
            predatorExecutor.logError("Exception when trying to delete files", e);
            failed = true;
        }
        predatorExecutor.logOutput("Final free space: " + predatorExecutor.retrieveFreeSpaceGB() + " GB");
        if (failed) {
            if (this.failBuild) {
                this.buildContext.getErrorCollection().addErrorMessage("[PredatorPreBuildAction] Failed to execute agent cleaning. Failing the build.");
            } else {
                predatorExecutor.logOutput("There was an exception in the previous predator steps. Predator is configured to not fail the build.");
            }
        }
        predatorExecutor.logOutput("Done");
        return this.buildContext;
    }

    public void setBuildLoggerManager(BuildLoggerManager buildLoggerManager) {
        this.buildLoggerManager = buildLoggerManager;
    }

    public void setBuildDirectoryManager(BuildDirectoryManager buildDirectoryManager) {
        this.buildDirectoryManager = buildDirectoryManager;
    }

    private boolean isRunningInDocker() {
        return new File("/.dockerenv").exists();
    }
}

