/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.predator.executor;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plugin.predator.PredatorConstants;
import com.atlassian.bamboo.plugin.predator.executor.ProcessWaiter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jezhumble.javasysmon.JavaSysMon;
import com.jezhumble.javasysmon.ProcessInfo;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.resource.NotSupportedException;
import org.apache.commons.io.FileSystemUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.AgeFileFilter;
import org.apache.commons.io.filefilter.EmptyFileFilter;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.jetbrains.annotations.NotNull;

public class PredatorExecutor {
    private static final Logger log = Logger.getLogger(PredatorExecutor.class);
    private static final long COMMAND_TIMEOUT_SECONDS = 120L;
    private BuildLogger buildLogger;

    public PredatorExecutor(BuildLogger buildLogger) {
        this.buildLogger = buildLogger;
    }

    public float retrieveFreeSpaceGB() {
        try {
            long freeSpaceKb = FileSystemUtils.freeSpaceKb();
            return new BigDecimal(freeSpaceKb).divide(new BigDecimal(0x100000)).floatValue();
        }
        catch (IOException e) {
            this.logError("Exception when trying to calculate free disk space, using maximum", e);
            return Float.MAX_VALUE;
        }
    }

    public void removeMavenStable(boolean deleteStableMaven, @NotNull File mavenLocalRepoDirectory, @NotNull Float ageStableToDelete, @NotNull Float minimumFreeDisk) throws IOException {
        if (!deleteStableMaven) {
            this.logOutput("Skipping the removal of maven stable artifacts");
            return;
        }
        if (!mavenLocalRepoDirectory.isDirectory()) {
            this.logOutput("Maven local repository " + mavenLocalRepoDirectory.getAbsolutePath() + "doesn't exist, skipping the removal of maven snapshots");
            return;
        }
        long cutoff = (long)((float)System.currentTimeMillis() - 8.64E7f * ageStableToDelete.floatValue());
        Iterator allFiles = FileUtils.iterateFiles((File)mavenLocalRepoDirectory, (IOFileFilter)new AgeFileFilter(cutoff), (IOFileFilter)TrueFileFilter.INSTANCE);
        float initialFreeDiskGB = this.retrieveFreeSpaceGB();
        int countDeleted = 0;
        float totalFreedDiskGB = 0.0f;
        while (allFiles.hasNext() && initialFreeDiskGB + totalFreedDiskGB < minimumFreeDisk.floatValue()) {
            File file = (File)allFiles.next();
            totalFreedDiskGB += (float)FileUtils.sizeOf((File)file) * 1.0f / 1.0737418E9f;
            FileUtils.deleteQuietly((File)file);
            ++countDeleted;
        }
        this.logOutput("Maven stable disk freed: " + totalFreedDiskGB + " GB, deleted " + countDeleted + " files");
    }

    public void removeMavenSnapshots(boolean deleteSnapshotsMaven, @NotNull File mavenLocalRepoDirectory) throws IOException {
        if (!deleteSnapshotsMaven) {
            this.logOutput("Skipping the removal of maven snapshots");
            return;
        }
        if (!mavenLocalRepoDirectory.isDirectory()) {
            this.logOutput("Maven local repository " + mavenLocalRepoDirectory.getAbsolutePath() + "doesn't exist, skipping the removal of maven snapshots");
            return;
        }
        Collection allFolders = FileUtils.listFilesAndDirs((File)mavenLocalRepoDirectory, (IOFileFilter)FalseFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
        ArrayList snapshotFolders = Lists.newArrayList((Iterable)Iterables.filter((Iterable)allFolders, input -> input.getName().endsWith("-SNAPSHOT")));
        this.logOutput("Deleting " + snapshotFolders.size() + " snapshot folders from " + mavenLocalRepoDirectory);
        long totalDisk = 0L;
        for (File snapshotFolder : snapshotFolders) {
            totalDisk += FileUtils.sizeOfDirectory((File)snapshotFolder);
            FileUtils.deleteQuietly((File)snapshotFolder);
        }
        this.logOutput("Maven snapshot disk freed: " + totalDisk / 0x40000000L + " GB");
    }

    public void removeEmptyArtifacts(@NotNull File mavenLocalRepoDirectory) {
        if (!mavenLocalRepoDirectory.isDirectory()) {
            this.logOutput("Maven local repository " + mavenLocalRepoDirectory.getAbsolutePath() + "doesn't exist, skipping the removal of empty artifacts");
            return;
        }
        Collection emptyArtifacts = FileUtils.listFiles((File)mavenLocalRepoDirectory, (IOFileFilter)EmptyFileFilter.EMPTY, (IOFileFilter)TrueFileFilter.INSTANCE);
        ArrayList emptyArtifactList = new ArrayList(emptyArtifacts);
        for (File file : emptyArtifactList) {
            FileUtils.deleteQuietly((File)file);
        }
        this.logOutput(emptyArtifactList.size() + " empty artifacts were found and deleted by Predator");
    }

    public void removeOldBuildWorkingDirectory(boolean removeBuildWorkingDir, boolean keepBuildWorkingDirActiveBranches, @NotNull File agentWorkingDir, @NotNull String jobKey, String[] activePlanKeys) {
        this.removeOldBuildWorkingDirectory(removeBuildWorkingDir, keepBuildWorkingDirActiveBranches, agentWorkingDir, jobKey, activePlanKeys, Executors.newSingleThreadExecutor());
    }

    @VisibleForTesting
    void removeOldBuildWorkingDirectory(boolean removeBuildWorkingDir, boolean keepBuildWorkingDirActiveBranches, @NotNull File agentWorkingDir, @NotNull String jobKey, String[] activePlanKeys, @NotNull ExecutorService deleteService) {
        if (!removeBuildWorkingDir) {
            this.logOutput("Skipping the removal of build working directory");
            return;
        }
        if (Os.isFamily((String)"windows")) {
            try {
                Path tempDir = Files.createTempDirectory("predator", new FileAttribute[0]);
                for (File location : agentWorkingDir.listFiles()) {
                    String locationName = location.getName();
                    if (locationName.equals(jobKey) || PredatorConstants.BUILD_FILES.contains(locationName)) continue;
                    if (keepBuildWorkingDirActiveBranches && !this.isActiveBranch(locationName, activePlanKeys)) {
                        this.logOutput("Skip deleting active branch in working directory " + locationName);
                        continue;
                    }
                    File cleanupLocation = new File(tempDir.toFile(), location.getName() + "-cleanup");
                    try {
                        if (location.isDirectory()) {
                            FileUtils.moveDirectory((File)location, (File)cleanupLocation);
                            continue;
                        }
                        if (location.isFile()) {
                            FileUtils.moveFile((File)location, (File)cleanupLocation);
                            continue;
                        }
                        this.logOutput("Skipping removing unknown file type, not a file or directory: " + locationName);
                    }
                    catch (IOException e) {
                        this.logError("Failed to move old build directory prior to deletion.", e);
                    }
                }
                deleteService.submit(() -> {
                    this.logOutput("Deleting old build directory \"" + tempDir.toString() + "\" on a background thread.");
                    FileUtils.deleteQuietly((File)tempDir.toFile());
                });
                deleteService.shutdown();
            }
            catch (IOException e) {
                this.logError("Failed to create a temporary directory", e);
            }
        } else {
            for (File location : agentWorkingDir.listFiles()) {
                String locationName = location.getName();
                if (locationName.equals(jobKey) || PredatorConstants.BUILD_FILES.contains(locationName)) continue;
                if (keepBuildWorkingDirActiveBranches && this.isActiveBranch(locationName, activePlanKeys)) {
                    this.logOutput("Skip deleting active branch in working directory " + locationName);
                    continue;
                }
                this.logOutput("Deleting folder " + location.getAbsolutePath());
                FileUtils.deleteQuietly((File)location);
            }
        }
    }

    boolean isActiveBranch(String folderName, String[] activePlanKeys) {
        PlanKey pk;
        try {
            pk = PlanKeys.getPlanKey((String)folderName);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
        String planKey = PlanKeys.isJobKey((PlanKey)pk) ? PlanKeys.getChainKeyFromJobKey((PlanKey)pk).getKey() : pk.getKey();
        return Arrays.asList(activePlanKeys).contains(planKey);
    }

    void killProcesses(@NotNull String processesToKillRegex) throws IOException, InterruptedException, NotSupportedException {
        String message = "The current OS does not support process management. Common causes: missing DLLs (msvcr100.dll) in Windows machines, running 32 bits OS";
        try {
            this.killProcesses(processesToKillRegex, new JavaSysMon());
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new NotSupportedException("The current OS does not support process management. Common causes: missing DLLs (msvcr100.dll) in Windows machines, running 32 bits OS", (Throwable)unsatisfiedLinkError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void killProcesses(@NotNull String processesToKillRegex, @NotNull JavaSysMon javaSysMon) throws IOException, InterruptedException, NotSupportedException {
        ProcessInfo currentProcess;
        if (StringUtils.isEmpty((CharSequence)processesToKillRegex)) {
            this.logOutput("Skipping processes killing ");
            return;
        }
        if (!javaSysMon.supportedPlatform()) {
            this.logError("Platform not supported. It's not possible to kill processes.");
            throw new NotSupportedException();
        }
        List<ProcessInfo> allProcesses = Arrays.asList(javaSysMon.processTable());
        ImmutableMap mappedProcesses = Maps.uniqueIndex(allProcesses, from -> from.getPid());
        final ArrayList currentPidTree = Lists.newArrayList();
        ProcessInfo process = currentProcess = (ProcessInfo)mappedProcesses.get(javaSysMon.currentPid());
        do {
            currentPidTree.add(process.getPid());
            this.logOutput("Identifying Bamboo agent process (or parent): " + process.toString());
        } while ((process = (ProcessInfo)mappedProcesses.get(process.getParentPid())) != null && process.getPid() != 0 && !currentPidTree.contains(process.getPid()));
        final Pattern patternRegex = Pattern.compile(processesToKillRegex, 2);
        ArrayList matchedProcesses = Lists.newArrayList((Iterable)Iterables.filter(allProcesses, (Predicate)new Predicate<ProcessInfo>(){

            public boolean apply(ProcessInfo processInfo) {
                try {
                    boolean toRet;
                    Integer pid = processInfo.getPid();
                    boolean bl = toRet = pid != 0 && pid != 1 && processInfo.getOwner().equals(currentProcess.getOwner()) && !currentPidTree.contains(pid) && !StringUtils.isBlank((CharSequence)processInfo.getCommand()) && patternRegex.matcher(processInfo.getCommand()).find();
                    if (toRet && PredatorExecutor.this.hackIsZombie(processInfo)) {
                        PredatorExecutor.this.logOutput(String.format("Skipping zombie process PID: %s\t Name: %s\t Owner: %s \t Command: %s", processInfo.getPid(), processInfo.getName(), processInfo.getOwner(), processInfo.getCommand()));
                        return false;
                    }
                    return toRet;
                }
                catch (NullPointerException e) {
                    PredatorExecutor.this.logError("Error retrieving PID of process " + processInfo.getName() + ". It is probably due to system permissions (e.g., a SSH command from other user). Ignoring this process. ");
                    return false;
                }
            }
        }));
        if (matchedProcesses.isEmpty()) {
            this.logOutput("No processes found for " + processesToKillRegex);
            return;
        }
        ExecutorService executor = Executors.newFixedThreadPool(10);
        for (ProcessInfo processInfo : matchedProcesses) {
            executor.submit(() -> {
                this.logOutput(String.format("Killing process PID: %s\t Name: %s\t Owner: %s \t Command: %s", processInfo.getPid(), processInfo.getName(), processInfo.getOwner(), processInfo.getCommand()));
                javaSysMon.killProcessTree(processInfo.getPid(), false);
            });
        }
        try {
            executor.shutdown();
            executor.awaitTermination(1L, TimeUnit.HOURS);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            this.logOutput("Waited for for 1 hour jobs in process kills pool to complete");
        }
        finally {
            executor.shutdownNow();
            this.logOutput("Shutdown of process kill pool finished");
        }
    }

    public void runCommands(@NotNull String[] commands, boolean runningInBambooDockerContainer) throws Exception {
        this.runCommandWaiters(Arrays.asList(commands).stream().map(t -> t.trim()).filter(t -> !t.isEmpty()).map(t -> {
            ProcessBuilder pb = new ProcessBuilder(StringUtils.split((String)t, (String)" "));
            pb.environment().put("DOCKER_PIPELINE", Boolean.toString(runningInBambooDockerContainer));
            return new ProcessWaiter(pb);
        }).collect(Collectors.toList()), 120L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runCommandWaiters(@NotNull List<ProcessWaiter> waiters, long timeoutSeconds) throws Exception {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        for (ProcessWaiter waiter : waiters) {
            this.logOutput(String.format("Running command '%s'", waiter.command()));
            try {
                Future<Integer> future = executor.submit(waiter);
                Integer exitCode = future.get(timeoutSeconds, TimeUnit.SECONDS);
                this.logOutput(String.format("Command '%s' completed with exit code %d", waiter.command(), (int)exitCode));
            }
            catch (TimeoutException te) {
                this.logWarning(String.format("Command '%s' skipped. Took too long to run, prematurely terminated.", waiter.command()));
            }
            catch (InterruptedException | ExecutionException e) {
                this.logWarning(String.format("Command '%s' skipped, continuing. This is almost never a cause of failed builds. Exception: \n%s", waiter.command(), e.getMessage()));
            }
            finally {
                waiter.destroy();
            }
        }
        executor.shutdown();
    }

    public void deleteFiles(@NotNull String[] files, @NotNull File homeDirectory, boolean force) {
        if (files.length == 0) {
            this.logOutput("Skipping selected files deletion ");
            return;
        }
        for (String fileName : files) {
            if (fileName.isEmpty()) continue;
            File file = new File(fileName.replaceFirst("^~", homeDirectory.getAbsolutePath()).trim());
            if (force || file.exists()) {
                this.logOutput("Deleting file " + file.getAbsolutePath());
                FileUtils.deleteQuietly((File)file);
                continue;
            }
            this.logOutput("File " + file.getAbsolutePath() + " does not exist.");
        }
    }

    public boolean shouldRunInThisAgent(@NotNull String name, @NotNull String agentsRegex) {
        return name.matches("(?i)" + agentsRegex);
    }

    void logError(String message) {
        this.buildLogger.addErrorLogEntry("[PredatorPreBuildAction] " + message);
        log.error((Object)("[PredatorPreBuildAction] " + message));
    }

    void logError(String message, Exception e) {
        this.buildLogger.addErrorLogEntry("[PredatorPreBuildAction] " + message, (Throwable)e);
        log.error((Object)("[PredatorPreBuildAction] " + message), (Throwable)e);
    }

    void logWarning(String message) {
        this.buildLogger.addBuildLogEntry("[PredatorPreBuildAction] " + message);
        log.warn((Object)("[PredatorPreBuildAction] " + message));
    }

    public void logOutput(String message) {
        this.buildLogger.addBuildLogEntry("[PredatorPreBuildAction] " + message);
        log.info((Object)("[PredatorPreBuildAction] " + message));
    }

    public void setBuildLogger(BuildLogger buildLogger) {
        this.buildLogger = buildLogger;
    }

    private boolean hackIsZombie(ProcessInfo processInfo) {
        File proc = new File("/proc/" + processInfo.getPid() + "/status");
        if (proc.exists() && proc.isFile()) {
            boolean bl;
            block9: {
                Stream<String> lines = Files.lines(proc.toPath());
                try {
                    bl = lines.filter(t -> t.contains("State") && t.contains("zombie")).findFirst().isPresent();
                    if (lines == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (lines != null) {
                            try {
                                lines.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        log.warn((Object)("Cannot read " + proc), (Throwable)ex);
                    }
                }
                lines.close();
            }
            return bl;
        }
        return false;
    }
}

