/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.predator.config;

import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.plugin.predator.PredatorPluginService;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.user.BambooAuthenticationContext;
import com.atlassian.user.User;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;

public class PredatorConfiguration
extends GlobalAdminAction {
    private final BambooAuthenticationContext bambooAuthenticationContext;
    private final BambooPermissionManager bambooPermissionManager;
    private final PredatorPluginService predatorPluginService;
    private String agentsRegex;
    private boolean skipDocker;
    private boolean failBuild;
    private String processesToKillRegex;
    private String commandsToRun;
    private boolean removeBuildWorkingDir;
    private boolean keepBuildWorkingDirActiveBranches;
    private boolean deleteSnapshotsMaven;
    private boolean deleteStableMaven;
    private String ageDaysStableToDelete;
    private String minimumFreeDiskGB;
    private String deleteFiles;

    public PredatorConfiguration(PredatorPluginService predatorPluginService, BambooAuthenticationContext bambooAuthenticationContext, BambooPermissionManager bambooPermissionManager) {
        this.bambooAuthenticationContext = bambooAuthenticationContext;
        this.bambooPermissionManager = bambooPermissionManager;
        this.predatorPluginService = predatorPluginService;
    }

    public String doExecute() throws Exception {
        User user = this.bambooAuthenticationContext.getUser();
        if (user != null && this.bambooPermissionManager.isAdmin(user.getName())) {
            return super.doExecute();
        }
        return "error";
    }

    public String doDefault() {
        this.agentsRegex = this.predatorPluginService.getAgentsRegex();
        this.skipDocker = this.predatorPluginService.getSkipDocker();
        this.failBuild = this.predatorPluginService.getFailBuild();
        this.processesToKillRegex = this.predatorPluginService.getProcessesToKillRegex();
        this.commandsToRun = this.predatorPluginService.getCommandsToRun();
        this.removeBuildWorkingDir = this.predatorPluginService.getRemoveBuildWorkingDir();
        this.keepBuildWorkingDirActiveBranches = this.predatorPluginService.getKeepBuildWorkingDirActiveBranches();
        this.deleteSnapshotsMaven = this.predatorPluginService.getDeleteSnapshotsMaven();
        this.deleteStableMaven = this.predatorPluginService.getDeleteStableMaven();
        this.ageDaysStableToDelete = this.predatorPluginService.getAgeDaysStableToDelete().toString();
        this.minimumFreeDiskGB = this.predatorPluginService.getMinimumFreeDiskGB().toString();
        this.deleteFiles = this.predatorPluginService.getDeleteFiles();
        return "success";
    }

    public String doEdit() {
        this.validate();
        if (this.hasAnyErrors()) {
            return "error";
        }
        this.predatorPluginService.setAgentsRegex(this.agentsRegex);
        this.predatorPluginService.setSkipDocker(this.skipDocker);
        this.predatorPluginService.setFailBuild(this.failBuild);
        this.predatorPluginService.setProcessesToKillRegex(this.processesToKillRegex);
        this.predatorPluginService.setCommandsToRun(this.commandsToRun);
        this.predatorPluginService.setRemoveBuildWorkingDir(this.removeBuildWorkingDir);
        this.predatorPluginService.setKeepBuildWorkingDirActiveBranches(this.keepBuildWorkingDirActiveBranches);
        this.predatorPluginService.setDeleteSnapshotsMaven(this.deleteSnapshotsMaven);
        this.predatorPluginService.setDeleteStableMaven(this.deleteStableMaven);
        this.predatorPluginService.setDeleteFiles(this.deleteFiles);
        if (this.deleteStableMaven) {
            this.predatorPluginService.setAgeDaysStableToDelete(Float.valueOf(Float.parseFloat(this.ageDaysStableToDelete)));
            this.predatorPluginService.setMinimumFreeDiskGB(Float.valueOf(Float.parseFloat(this.minimumFreeDiskGB)));
        }
        this.addActionMessage(this.getText("predator.plan.config.success"));
        return "success";
    }

    public void validate() {
        super.validate();
        if (StringUtils.isEmpty((String)this.agentsRegex)) {
            this.addFieldError("agentsRegex", this.getText("predator.error.empty"));
        } else {
            try {
                Pattern.compile(this.agentsRegex);
            }
            catch (PatternSyntaxException e) {
                this.addFieldError("agentsRegex", this.getText("predator.error.regex"));
            }
        }
        if (!this.processesToKillRegex.isEmpty()) {
            try {
                Pattern.compile(this.processesToKillRegex);
            }
            catch (PatternSyntaxException e) {
                this.addFieldError("processesToKillRegex", this.getText("predator.error.regex"));
            }
        }
        if (this.deleteStableMaven) {
            if (StringUtils.isEmpty((String)this.ageDaysStableToDelete)) {
                this.addFieldError("ageDaysStableToDelete", this.getText("predator.error.empty"));
            } else {
                try {
                    Float.parseFloat(this.ageDaysStableToDelete);
                }
                catch (NumberFormatException e) {
                    this.addFieldError("ageDaysStableToDelete", this.getText("predator.error.number"));
                }
            }
            if (StringUtils.isEmpty((String)this.minimumFreeDiskGB)) {
                this.addFieldError("minimumFreeDiskGB", this.getText("predator.error.empty"));
            } else {
                try {
                    Float.parseFloat(this.minimumFreeDiskGB);
                }
                catch (NumberFormatException e) {
                    this.addFieldError("minimumFreeDiskGB", this.getText("predator.error.number"));
                }
            }
        }
    }

    public void setAgentsRegex(String agentsRegex) {
        this.agentsRegex = agentsRegex;
    }

    public void setSkipDocker(boolean skipDocker) {
        this.skipDocker = skipDocker;
    }

    public void setFailBuild(boolean failBuild) {
        this.failBuild = failBuild;
    }

    public void setProcessesToKillRegex(String processesToKillRegex) {
        this.processesToKillRegex = processesToKillRegex;
    }

    public void setCommandsToRun(String commandsToRun) {
        this.commandsToRun = commandsToRun;
    }

    public void setRemoveBuildWorkingDir(boolean removeBuildWorkingDir) {
        this.removeBuildWorkingDir = removeBuildWorkingDir;
    }

    public void setKeepBuildWorkingDirActiveBranches(boolean keepBuildWorkingDirActiveBranches) {
        this.keepBuildWorkingDirActiveBranches = keepBuildWorkingDirActiveBranches;
    }

    public void setDeleteSnapshotsMaven(boolean deleteSnapshotsMaven) {
        this.deleteSnapshotsMaven = deleteSnapshotsMaven;
    }

    public void setDeleteStableMaven(boolean deleteStableMaven) {
        this.deleteStableMaven = deleteStableMaven;
    }

    public void setAgeDaysStableToDelete(String ageDaysStableToDelete) {
        this.ageDaysStableToDelete = ageDaysStableToDelete;
    }

    public void setMinimumFreeDiskGB(String minimumFreeDiskGB) {
        this.minimumFreeDiskGB = minimumFreeDiskGB;
    }

    public String getAgentsRegex() {
        return this.agentsRegex;
    }

    public boolean isSkipDocker() {
        return this.skipDocker;
    }

    public boolean isFailBuild() {
        return this.failBuild;
    }

    public String getProcessesToKillRegex() {
        return this.processesToKillRegex;
    }

    public String getCommandsToRun() {
        return this.commandsToRun;
    }

    public boolean isRemoveBuildWorkingDir() {
        return this.removeBuildWorkingDir;
    }

    public boolean isKeepBuildWorkingDirActiveBranches() {
        return this.keepBuildWorkingDirActiveBranches;
    }

    public boolean isDeleteSnapshotsMaven() {
        return this.deleteSnapshotsMaven;
    }

    public boolean isDeleteStableMaven() {
        return this.deleteStableMaven;
    }

    public String getAgeDaysStableToDelete() {
        return this.ageDaysStableToDelete;
    }

    public String getMinimumFreeDiskGB() {
        return this.minimumFreeDiskGB;
    }

    public String getDeleteFiles() {
        return this.deleteFiles;
    }

    public void setDeleteFiles(String deleteFiles) {
        this.deleteFiles = deleteFiles;
    }
}

