/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.predator;

import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.plugin.predator.PredatorPluginService;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.google.common.base.Preconditions;
import org.apache.log4j.Logger;

public class DefaultPredatorPluginService
implements PredatorPluginService {
    private static final Logger log = Logger.getLogger(DefaultPredatorPluginService.class);
    private final BandanaManager bandanaManager;
    private String agentsRegex;
    private Boolean skipDocker;
    private Boolean failBuild;
    private String processesToKillRegex;
    private String commandsToRun;
    private Boolean removeBuildWorkingDir;
    private Boolean keepBuildWorkingDirActiveBranches;
    private Boolean deleteSnapshotsMaven;
    private Boolean deleteStableMaven;
    private Float ageDaysStableToDelete;
    private Float minimumFreeDiskGB;
    private String deleteFiles;

    public DefaultPredatorPluginService(BandanaManager bandanaManager) {
        this.bandanaManager = (BandanaManager)Preconditions.checkNotNull((Object)bandanaManager);
        this.failBuild = (Boolean)this.retrieveValueWithDefault(bandanaManager, "fail", false);
        this.skipDocker = (Boolean)this.retrieveValueWithDefault(bandanaManager, "skipDocker", false);
        this.agentsRegex = (String)this.retrieveValueWithDefault(bandanaManager, "agents", ".*");
        this.processesToKillRegex = (String)this.retrieveValueWithDefault(bandanaManager, "processes", "");
        this.commandsToRun = (String)this.retrieveValueWithDefault(bandanaManager, "commands", "");
        this.removeBuildWorkingDir = (Boolean)this.retrieveValueWithDefault(bandanaManager, "delete.workingdir", false);
        this.keepBuildWorkingDirActiveBranches = (Boolean)this.retrieveValueWithDefault(bandanaManager, "keep.workingdir.activebranches", false);
        this.deleteSnapshotsMaven = (Boolean)this.retrieveValueWithDefault(bandanaManager, "delete.snapshot", false);
        this.deleteStableMaven = (Boolean)this.retrieveValueWithDefault(bandanaManager, "delete.stable", false);
        this.ageDaysStableToDelete = (Float)this.retrieveValueWithDefault(bandanaManager, "delete.stable.age", Float.valueOf(0.0f));
        this.minimumFreeDiskGB = (Float)this.retrieveValueWithDefault(bandanaManager, "delete.stable.free", Float.valueOf(0.0f));
        this.deleteFiles = (String)this.retrieveValueWithDefault(bandanaManager, "delete.files", "");
    }

    @Override
    public String getAgentsRegex() {
        return this.agentsRegex;
    }

    @Override
    public void setAgentsRegex(String agentsRegex) {
        this.agentsRegex = agentsRegex;
        this.setBandanaValue("agents", agentsRegex);
    }

    @Override
    public Boolean getSkipDocker() {
        return this.skipDocker;
    }

    @Override
    public void setSkipDocker(Boolean skipDocker) {
        this.skipDocker = skipDocker;
        this.setBandanaValue("skipDocker", skipDocker);
    }

    @Override
    public Boolean getFailBuild() {
        return this.failBuild;
    }

    @Override
    public void setFailBuild(Boolean failBuild) {
        this.failBuild = failBuild;
        this.setBandanaValue("fail", failBuild);
    }

    @Override
    public String getProcessesToKillRegex() {
        return this.processesToKillRegex;
    }

    @Override
    public void setProcessesToKillRegex(String processesToKillRegex) {
        this.processesToKillRegex = processesToKillRegex;
        this.setBandanaValue("processes", processesToKillRegex);
    }

    @Override
    public String getCommandsToRun() {
        return this.commandsToRun;
    }

    @Override
    public void setCommandsToRun(String commandsToRun) {
        this.commandsToRun = commandsToRun;
        this.setBandanaValue("commands", commandsToRun);
    }

    @Override
    public Boolean getRemoveBuildWorkingDir() {
        return this.removeBuildWorkingDir;
    }

    @Override
    public Boolean getKeepBuildWorkingDirActiveBranches() {
        return this.keepBuildWorkingDirActiveBranches;
    }

    @Override
    public void setRemoveBuildWorkingDir(Boolean removeBuildWorkingDir) {
        this.removeBuildWorkingDir = removeBuildWorkingDir;
        this.setBandanaValue("delete.workingdir", removeBuildWorkingDir);
    }

    @Override
    public void setKeepBuildWorkingDirActiveBranches(Boolean keepBuildWorkingDirActiveBranches) {
        this.keepBuildWorkingDirActiveBranches = keepBuildWorkingDirActiveBranches;
        this.setBandanaValue("keep.workingdir.activebranches", keepBuildWorkingDirActiveBranches);
    }

    @Override
    public Boolean getDeleteSnapshotsMaven() {
        return this.deleteSnapshotsMaven;
    }

    @Override
    public void setDeleteSnapshotsMaven(Boolean deleteSnapshotsMaven) {
        this.deleteSnapshotsMaven = deleteSnapshotsMaven;
        this.setBandanaValue("delete.snapshot", deleteSnapshotsMaven);
    }

    @Override
    public Boolean getDeleteStableMaven() {
        return this.deleteStableMaven;
    }

    @Override
    public void setDeleteStableMaven(Boolean deleteStableMaven) {
        this.deleteStableMaven = deleteStableMaven;
        this.setBandanaValue("delete.stable", deleteStableMaven);
    }

    @Override
    public Float getAgeDaysStableToDelete() {
        return this.ageDaysStableToDelete;
    }

    @Override
    public void setAgeDaysStableToDelete(Float ageDaysStableToDelete) {
        this.ageDaysStableToDelete = ageDaysStableToDelete;
        this.setBandanaValue("delete.stable.age", ageDaysStableToDelete);
    }

    @Override
    public Float getMinimumFreeDiskGB() {
        return this.minimumFreeDiskGB;
    }

    @Override
    public void setMinimumFreeDiskGB(Float minimumFreeDiskGB) {
        this.minimumFreeDiskGB = minimumFreeDiskGB;
        this.setBandanaValue("delete.stable.free", minimumFreeDiskGB);
    }

    @Override
    public String getDeleteFiles() {
        return this.deleteFiles;
    }

    @Override
    public void setDeleteFiles(String deleteFiles) {
        this.deleteFiles = deleteFiles;
        this.setBandanaValue("delete.files", deleteFiles);
    }

    private void setBandanaValue(String key, Object value) {
        this.bandanaManager.setValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, "com.atlassian.bamboo.plugin.predator." + key, value);
    }

    private Object retrieveValueWithDefault(BandanaManager bandanaManager, String key, Object defaultValue) {
        Object retrievedObject;
        Object bandanaObject = bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, "com.atlassian.bamboo.plugin.predator." + key);
        if (bandanaObject != null) {
            try {
                retrievedObject = bandanaObject;
            }
            catch (Exception e) {
                log.error((Object)("Unable to retrieve " + key + ", using default: " + defaultValue));
                bandanaManager.removeValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, key);
                retrievedObject = defaultValue;
            }
        } else {
            retrievedObject = defaultValue;
        }
        return retrievedObject;
    }
}

