/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.buildtimes;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.bamboo.build.BuildExecutionManager;
import com.atlassian.bamboo.build.PlanResultsAction;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.cache.ImmutableChainStage;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plugin.buildtimes.JobTime;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

@AnonymousSiteAccess
public class ViewBuildTimes
extends PlanResultsAction {
    private boolean isJob;
    private AgentManager agentManager;
    private BuildExecutionManager buildExecutionManager;
    private long averageBuildTime;
    private long elapsedTime;
    public List<JobTime> jobTimes = new ArrayList<JobTime>();
    public List<Integer> stageJobs = new ArrayList<Integer>();

    public String doExecute() throws Exception {
        String result = super.doExecute();
        String buildKey = this.getBuildKey();
        this.isJob = buildKey.split("-").length == 3;
        return result;
    }

    public String doJSON() throws Exception {
        String result = super.doExecute();
        ChainResultsSummary chainResultsSummary = this.getChainResultsSummary();
        ImmutableChain plan = (ImmutableChain)chainResultsSummary.getPlanIfExists().orElseThrow(() -> new IllegalStateException("Unable to find Plan for " + chainResultsSummary.getPlanKey()));
        this.jobTimes = this.getJobTimes(chainResultsSummary);
        this.averageBuildTime = TimeUnit.MILLISECONDS.toSeconds(plan.getAverageBuildDuration());
        this.stageJobs = this.getStageDivisions(plan);
        this.elapsedTime = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - chainResultsSummary.getQueueTime().getTime());
        return result;
    }

    public JSONObject getJsonObject() throws JSONException {
        JSONObject jsonObject = super.getJsonObject();
        List<JSONObject> jsonTimes = this.getJsonTimes(this.jobTimes);
        jsonObject.put("jobs", jsonTimes);
        jsonObject.put("stageJobs", this.stageJobs);
        jsonObject.put("averageBuildTime", this.averageBuildTime);
        jsonObject.put("elapsedTime", this.elapsedTime);
        return jsonObject;
    }

    private List<JSONObject> getJsonTimes(List<JobTime> jobTimes) throws JSONException {
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        for (JobTime jobTime : jobTimes) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.append("jobName", (Object)jobTime.getJobName());
            jsonObject.append("duration", (Object)(jobTime.getVcsUpdatingDuration() + jobTime.getBuildingDuration()));
            jsonObject.append("queueTime", (Object)jobTime.getQueueDuration());
            jsonObject.append("totalDuration", (Object)jobTime.getTotalDuration());
            jsonObject.append("result", (Object)jobTime.getResult());
            jsonObject.append("agentName", (Object)jobTime.getAgentName());
            jsonObject.append("preQueueTime", (Object)jobTime.getPreQueuedDuration());
            jsonObject.append("vcsUpdatingTime", (Object)jobTime.getVcsUpdatingDuration());
            jsonObject.append("buildingTime", (Object)jobTime.getBuildingDuration());
            jsonObject.append("agentId", (Object)jobTime.getAgentId());
            jsonObject.append("rerun", (Object)jobTime.isRerun());
            result.add(jsonObject);
        }
        return result;
    }

    private List<Integer> getStageDivisions(ImmutableChain plan) {
        ArrayList<Integer> stageDivisions = new ArrayList<Integer>();
        List stages = plan.getStages();
        for (ImmutableChainStage stage : stages) {
            stageDivisions.add(stage.getJobs().size());
        }
        return stageDivisions;
    }

    private List<JobTime> getJobTimes(ChainResultsSummary chainResultsSummary) {
        ArrayList<JobTime> jobTimes = new ArrayList<JobTime>();
        long maxTime = 0L;
        if (chainResultsSummary != null) {
            List jobResultSummaries = chainResultsSummary.getOrderedJobResultSummaries();
            for (ResultsSummary jobResultSummary : jobResultSummaries) {
                JobTime jobTime = new JobTime((BuildResultsSummary)jobResultSummary, chainResultsSummary.getQueueTime(), this.agentManager, this.buildExecutionManager);
                jobTimes.add(jobTime);
                maxTime = Math.max(jobTime.getTotalDuration(), maxTime);
            }
        }
        return jobTimes;
    }

    private ChainResultsSummary getChainResultsSummary() {
        if (this.resultsSummary instanceof ChainResultsSummary) {
            return (ChainResultsSummary)this.resultsSummary;
        }
        return this.resultsSummaryManager.getParentResultSummary(this.resultsSummary);
    }

    public void setAgentManager(AgentManager agentManager) {
        this.agentManager = agentManager;
    }

    public boolean getIsJob() {
        return this.isJob;
    }

    public long getAverageBuildTime() {
        return this.averageBuildTime;
    }

    public void setBuildExecutionManager(BuildExecutionManager buildExecutionManager) {
        this.buildExecutionManager = buildExecutionManager;
    }
}

