/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.buildtimes;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildExecutionManager;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.v2.build.CurrentlyBuilding;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class JobTime {
    private long preQueuedDuration;
    private long jobQueueDuration;
    private long buildingDuration;
    private long vcsUpdatingDuration;
    private long totalDuration;
    private String jobName;
    private String result;
    private Boolean rerun;
    private String agentName = "Unknown";
    private long agentId = -1L;

    public JobTime(BuildResultsSummary resultsSummary, Date startTime, AgentManager agentManager, BuildExecutionManager buildExecutionManager) {
        CurrentlyBuilding currentlyBuilding;
        Date queueTime;
        try {
            this.agentId = resultsSummary.getBuildAgentId();
            this.agentName = agentManager.getAgent(this.agentId).getName();
        }
        catch (NullPointerException e) {
            this.agentName = "Unknown";
            this.agentId = -1L;
        }
        this.rerun = resultsSummary.isRebuild();
        this.jobName = resultsSummary.getPlanName();
        this.result = "current";
        if (resultsSummary.isFinished()) {
            this.result = "red";
            if (resultsSummary.isSuccessful()) {
                this.result = "green";
            }
        } else if (resultsSummary.isPending()) {
            this.result = "pending";
        } else if (resultsSummary.isQueued()) {
            this.result = "queued";
        } else if (resultsSummary.isNotBuilt()) {
            this.result = "not built";
        }
        this.preQueuedDuration = (queueTime = resultsSummary.getQueueTime()) != null ? Math.max(TimeUnit.MILLISECONDS.toSeconds(queueTime.getTime() - startTime.getTime()), 0L) : 0L;
        this.jobQueueDuration = TimeUnit.MILLISECONDS.toSeconds(resultsSummary.getQueueDuration());
        this.vcsUpdatingDuration = TimeUnit.MILLISECONDS.toSeconds(resultsSummary.getVcsUpdateDuration());
        this.buildingDuration = TimeUnit.MILLISECONDS.toSeconds(resultsSummary.getDuration());
        if (this.result.equals("current") && (currentlyBuilding = buildExecutionManager.getCurrentlyBuildingByPlanResultKey((ResultKey)resultsSummary.getPlanResultKey())) != null && !currentlyBuilding.isUpdatingVcs()) {
            this.buildingDuration = Math.max(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - startTime.getTime()) - this.jobQueueDuration - this.vcsUpdatingDuration - this.preQueuedDuration, 0L);
        }
        this.totalDuration = this.jobQueueDuration + this.vcsUpdatingDuration + this.buildingDuration + this.preQueuedDuration;
    }

    public String getResult() {
        return this.result;
    }

    public long getPreQueuedDuration() {
        return this.preQueuedDuration;
    }

    public long getQueueDuration() {
        return this.jobQueueDuration;
    }

    public long getBuildingDuration() {
        return this.buildingDuration;
    }

    public long getVcsUpdatingDuration() {
        return this.vcsUpdatingDuration;
    }

    public String getJobName() {
        return this.jobName;
    }

    public long getTotalDuration() {
        return this.totalDuration;
    }

    public String getAgentName() {
        return this.agentName;
    }

    public long getAgentId() {
        return this.agentId;
    }

    public Boolean isRerun() {
        return this.rerun;
    }
}

