/*
 * Decompiled with CFR 0.152.
 */
package com.aq.aqconnect;

import aqPluginCore.AQFormValidate;
import aqPluginCore.AQRestClient;
import aqPluginCore.AQUtils;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskConfiguratorHelper;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.BambooImport;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class AQPluginTaskConfigurator
extends AbstractTaskConfigurator {
    public static final String APP_URL = "appURL";
    public static final String API_KEY = "apiKey";
    public static final String USERNAME = "userName";
    public static final String TENANT_CODE = "tenantCode";
    public static final String JOB_ID = "jobId";
    public static final String RUN_PARAM_STR = "runParamStr";
    public static final String PROXY_HOST = "proxyHost";
    public static final String PROXY_PORT = "proxyPort";
    public static final String STEP_FAILURE_THRESHOLD = "stepFailureThreshold";
    public static final String MAX_WAIT_TIME_IN_MINS = "maxWaitTimeInMins";
    private final TaskConfiguratorHelper taskConfiguratorHelper;

    @Autowired
    public AQPluginTaskConfigurator(@BambooImport TaskConfiguratorHelper taskConfiguratorHelper) {
        this.taskConfiguratorHelper = taskConfiguratorHelper;
    }

    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        this.taskConfiguratorHelper.populateTaskConfigMapWithActionParameters(config, params, this.getFieldsToCopy());
        return config;
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        this.taskConfiguratorHelper.populateContextWithConfiguration(context, taskDefinition, this.getFieldsToCopy());
    }

    protected List<String> getFieldsToCopy() {
        return Arrays.asList(APP_URL, USERNAME, API_KEY, TENANT_CODE, JOB_ID, RUN_PARAM_STR, PROXY_HOST, PROXY_PORT, STEP_FAILURE_THRESHOLD, MAX_WAIT_TIME_IN_MINS);
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        super.validate(params, errorCollection);
        String appURL = params.getString(APP_URL);
        String apiKey = params.getString(API_KEY);
        String jobId = params.getString(JOB_ID);
        String runParamStr = params.getString(RUN_PARAM_STR);
        String proxyHost = params.getString(PROXY_HOST);
        String proxyPort = params.getString(PROXY_PORT);
        String userName = params.getString(USERNAME);
        String tenantCode = params.getString(TENANT_CODE);
        String stepFailureThreshold = params.getString(STEP_FAILURE_THRESHOLD);
        String maxWaitTimeInMins = params.getString(MAX_WAIT_TIME_IN_MINS);
        String connectionErrorPlaceholder = PROXY_PORT;
        boolean isInvalid = false;
        AQFormValidate formValidate = new AQFormValidate();
        String res = formValidate.validateAppURL(appURL);
        if (res != null) {
            errorCollection.addError(APP_URL, res);
            isInvalid = true;
        }
        if ((res = formValidate.validateJobID(jobId)) != null) {
            errorCollection.addError(JOB_ID, res);
            isInvalid = true;
        }
        if ((res = formValidate.validateUserId(userName)) != null) {
            errorCollection.addError(USERNAME, res);
            isInvalid = true;
        }
        if ((res = formValidate.validateTenantCode(tenantCode)) != null) {
            errorCollection.addError(TENANT_CODE, res);
            isInvalid = true;
        }
        if ((res = formValidate.validateAPIKey(apiKey)) != null) {
            errorCollection.addError(API_KEY, res);
            isInvalid = true;
        }
        if (!isInvalid) {
            try {
                AQRestClient aqRestClient = null;
                aqRestClient = AQRestClient.getInstance();
                AQUtils aqUtils = new AQUtils();
                String payload = aqUtils.getRunParamJsonPayload(runParamStr);
                aqRestClient.setUpBaseURL(appURL, tenantCode);
                aqRestClient.disableSSLChecks(true);
                if (proxyHost != null && proxyPort != null && proxyHost.length() > 0 && proxyPort.length() > 0) {
                    aqRestClient.setUpProxy(proxyHost.trim(), Integer.parseInt(proxyPort.trim()));
                } else {
                    aqRestClient.setUpProxy("", 0);
                }
                String error_res = aqRestClient.testConnection(apiKey, userName, jobId, payload, 15);
                if (error_res == null) {
                    errorCollection.addError(PROXY_PORT, "Connection Error: Something in plugin went wrong");
                } else if (error_res.length() > 0) {
                    errorCollection.addError(PROXY_PORT, "Connection Error: " + error_res);
                }
            }
            catch (Exception e) {
                errorCollection.addError(PROXY_PORT, "Connection Error: " + e.getMessage());
            }
        }
    }
}

