/*
 * Decompiled with CFR 0.152.
 */
package com.aq.aqconnect;

import aqPluginCore.AQConstants;
import aqPluginCore.AQException;
import aqPluginCore.AQRestClient;
import aqPluginCore.AQUtils;
import com.aq.aqconnect.AQPluginTaskConsoleLogger;
import com.aq.aqconnect.AQPluginTestResultReportGenerator;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.CommonTaskType;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import java.util.Map;
import org.json.simple.JSONObject;

@Scanned
public class AQPluginTask
implements CommonTaskType {
    public static final String APP_URL = "appURL";
    public static final String API_KEY = "apiKey";
    public static final String USERNAME = "userName";
    public static final String TENANT_CODE = "tenantCode";
    public static final String JOB_ID = "jobId";
    public static final String RUN_PARAM_STR = "runParamStr";
    public static final String PROXY_HOST = "proxyHost";
    public static final String PROXY_PORT = "proxyPort";
    public static final String STEP_FAILURE_THRESHOLD = "stepFailureThreshold";
    public static final String MAX_WAIT_TIME_IN_MINS = "maxWaitTimeInMins";

    private void log(BuildLogger logger, String msg) {
        logger.addBuildLogEntry(msg);
    }

    private String prepareAQBuildData(String status, long passCount, long failCount, long notRunCount, String reportLink) {
        JSONObject obj = new JSONObject();
        obj.put("status", status);
        obj.put("pass", passCount);
        obj.put("fail", failCount);
        obj.put("notRun", notRunCount);
        obj.put("reportLink", reportLink);
        return obj.toJSONString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskResult execute(CommonTaskContext taskContext) throws TaskException {
        BuildLogger buildLogger = taskContext.getBuildLogger();
        AQPluginTaskConsoleLogger logger = new AQPluginTaskConsoleLogger(buildLogger);
        ConfigurationMap conf = taskContext.getConfigurationMap();
        boolean isJobFailed = false;
        Map customBuildData = taskContext.getCommonContext().getCurrentResult().getCustomBuildData();
        try {
            int failureThreshold;
            logger.println("******************************************");
            logger.println("*** Begin: ACCELQ Test Automation Step ***");
            logger.println("******************************************");
            logger.println();
            String proxyPort = (String)conf.get((Object)PROXY_PORT);
            String proxyHost = (String)conf.get((Object)PROXY_HOST);
            AQRestClient aqPluginRESTClient = AQRestClient.getInstance();
            AQUtils aqUtils = new AQUtils();
            aqPluginRESTClient.setUpBaseURL(((String)conf.get((Object)APP_URL)).trim(), ((String)conf.get((Object)TENANT_CODE)).trim());
            aqPluginRESTClient.disableSSLChecks(true);
            if (proxyHost != null && proxyPort != null && proxyHost.length() > 0 && proxyPort.length() > 0) {
                aqPluginRESTClient.setUpProxy(proxyHost.trim(), Integer.parseInt(proxyPort.trim()));
            } else {
                aqPluginRESTClient.setUpProxy("", 0);
            }
            String runParamJsonPayload = aqUtils.getRunParamJsonPayload((String)conf.get((Object)RUN_PARAM_STR));
            int maxWaitTime = 0;
            maxWaitTime = conf.get((Object)MAX_WAIT_TIME_IN_MINS) == null || ((String)conf.get((Object)MAX_WAIT_TIME_IN_MINS)).equals("") ? 15 : Integer.parseInt((String)conf.get((Object)MAX_WAIT_TIME_IN_MINS));
            String res = aqPluginRESTClient.testConnection((String)conf.get((Object)API_KEY), (String)conf.get((Object)USERNAME), (String)conf.get((Object)JOB_ID), runParamJsonPayload, maxWaitTime);
            if (res == null) {
                throw new AQException("Connection Error: Something in plugin went wrong");
            }
            if (res.length() > 0) {
                throw new AQException("Connection Error: " + res);
            }
            JSONObject realJobObj = aqPluginRESTClient.triggerJob((String)conf.get((Object)API_KEY), (String)conf.get((Object)USERNAME), (String)conf.get((Object)JOB_ID), runParamJsonPayload, maxWaitTime);
            if (realJobObj == null) {
                throw new AQException("Unable to submit the Job, check plugin log stack");
            }
            if (realJobObj.get("cause") != null) {
                throw new AQException((String)realJobObj.get("cause"));
            }
            long realJobPid = (Long)realJobObj.get("pid");
            long passCount = 0L;
            long failCount = 0L;
            long runningCount = 0L;
            long totalCount = 0L;
            long notRunCount = 0L;
            String jobStatus = "";
            String resultAccessURL = aqPluginRESTClient.getResultExternalAccessURL(Long.toString(realJobPid), ((String)conf.get((Object)TENANT_CODE)).trim());
            boolean error = false;
            boolean hasLoggedLinks = false;
            boolean attempt = false;
            long startTime = System.currentTimeMillis();
            String threshold = (String)conf.get((Object)STEP_FAILURE_THRESHOLD);
            if (threshold == null || threshold.equals("")) {
                threshold = "0";
            }
            boolean isDouble = threshold.indexOf(".") != -1;
            int n = failureThreshold = isDouble ? Double.valueOf(threshold).intValue() : Integer.parseInt(threshold);
            do {
                JSONObject summaryObj;
                if ((summaryObj = aqPluginRESTClient.getJobSummary(realJobPid, (String)conf.get((Object)API_KEY), (String)conf.get((Object)USERNAME))).containsKey("aq_statusCode")) {
                    error = true;
                    logger.println("Warn: Issue fetching Job Summary, Status Code: " + summaryObj.get("aq_statusCode"));
                } else {
                    error = false;
                }
                if (!error) {
                    if (summaryObj.get("cause") != null) {
                        throw new AQException((String)summaryObj.get("cause"));
                    }
                    if (summaryObj.get("summary") != null) {
                        summaryObj = (JSONObject)summaryObj.get("summary");
                    }
                    passCount = (Long)summaryObj.get("pass");
                    failCount = (Long)summaryObj.get("fail");
                    notRunCount = (Long)summaryObj.get("notRun");
                    if (!attempt) {
                        attempt = true;
                        String jobPurpose = (String)summaryObj.get("purpose");
                        String scenarioName = (String)summaryObj.get("scnName");
                        String testSuiteName = (String)summaryObj.get("testSuiteName");
                        Long totalTestCases = (Long)summaryObj.get("testcaseCount");
                        if (testSuiteName != null && testSuiteName.length() > 0) {
                            logger.println("Test Suite Name: " + testSuiteName);
                        } else {
                            logger.println("Scenario Name: " + scenarioName);
                        }
                        logger.println("Purpose: " + jobPurpose);
                        logger.println("Total Test Cases: " + totalTestCases);
                        logger.println("Step Failure threshold: " + threshold);
                        logger.println("Max Wait Time in Minutes: " + maxWaitTime);
                        logger.println();
                        if (isDouble) {
                            logger.println("Warning: Invalid value (" + threshold + ") passed for Step Failure Threshold. Truncating the value to " + failureThreshold + " (Only integers between 0 and 100, and -1 are allowed).");
                        }
                        if (failureThreshold <= -2 || failureThreshold >= 101) {
                            logger.println("Warning: Ignoring the Step Failure threshold. Invalid value (" + failureThreshold + ") passed. Valid values are 0 to 100, or -1 to ignore threshold.");
                            failureThreshold = 0;
                        }
                    }
                    if (!(jobStatus = ((String)summaryObj.get("status")).toUpperCase()).equals(AQConstants.TEST_JOB_STATUS.SCHEDULED.getStatus().toUpperCase()) && !hasLoggedLinks) {
                        hasLoggedLinks = true;
                        logger.println("Results Link: " + resultAccessURL);
                        logger.println("Need to abort? Click on the link above, login to ACCELQ and abort the run.");
                        logger.println();
                    }
                    if (jobStatus.equals(AQConstants.TEST_JOB_STATUS.COMPLETED.getStatus().toUpperCase())) {
                        res = aqUtils.getFormattedTime((Long)summaryObj.get("startTimestamp"), (Long)summaryObj.get("completedTimestamp"));
                        logger.println("Status: " + summaryObj.get("status").toString().toUpperCase() + " (" + res.trim() + ")");
                    } else {
                        logger.println("Status: " + summaryObj.get("status").toString().toUpperCase());
                    }
                    if (hasLoggedLinks) {
                        totalCount = passCount + failCount + notRunCount;
                        logger.println("Total " + totalCount + ": " + passCount + " Pass / " + failCount + " Fail");
                        logger.println();
                    }
                    customBuildData.put("AQReportInfo", this.prepareAQBuildData((String)summaryObj.get("status"), passCount, failCount, notRunCount, resultAccessURL));
                    if (jobStatus.equals(AQConstants.TEST_JOB_STATUS.SCHEDULED.getStatus().toUpperCase()) && aqUtils.isWaitTimeExceeded(startTime, maxWaitTime)) {
                        throw new AQException(">>> No agent available to pickup the job");
                    }
                }
                Thread.sleep(30000L);
            } while (!jobStatus.equals(AQConstants.TEST_JOB_STATUS.COMPLETED.getStatus().toUpperCase()) && !jobStatus.equals(AQConstants.TEST_JOB_STATUS.ABORTED.getStatus().toUpperCase()) && !jobStatus.equals(AQConstants.TEST_JOB_STATUS.FAILED.getStatus().toUpperCase()) && !jobStatus.equals(AQConstants.TEST_JOB_STATUS.ERROR.getStatus().toUpperCase()));
            isJobFailed = jobStatus.equals(AQConstants.TEST_JOB_STATUS.ABORTED.getStatus().toUpperCase()) || jobStatus.equals(AQConstants.TEST_JOB_STATUS.FAILED.getStatus().toUpperCase()) || jobStatus.equals(AQConstants.TEST_JOB_STATUS.ERROR.getStatus().toUpperCase());
            double failCount_ = Long.valueOf(failCount).doubleValue();
            double totalCount_ = Long.valueOf(totalCount).doubleValue();
            int failedPercentage = (int)(failCount_ / totalCount_ * 100.0);
            logger.println("Results Link: " + resultAccessURL);
            logger.println();
            new AQPluginTestResultReportGenerator().generateReport(taskContext.getRootDirectory().getAbsolutePath(), resultAccessURL);
            if (isJobFailed) {
                throw new AQException(">>> Run Failed");
            }
            if (failCount > 0L && failureThreshold != -1 && failedPercentage >= failureThreshold) {
                throw new AQException(">>> Automation test step failed (test case failure count exceeds the threshold limit)");
            }
            TaskResult taskResult = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).success().build();
            return taskResult;
        }
        catch (Exception exception) {
            buildLogger.addErrorLogEntry(exception.getMessage());
            TaskResult taskResult = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failed().build();
            return taskResult;
        }
        finally {
            logger.println("**********************************************");
            logger.println("*** Completed: ACCELQ Test Automation Step ***");
            logger.println("**********************************************");
            logger.println();
        }
    }
}

