/*
 * Decompiled with CFR 0.152.
 */
package aqPluginCore;

import java.util.Date;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class AQUtils {
    public StringEntity getRunParam(String jobId, String runParam, int expireTimeInMinutes) throws ParseException {
        JSONObject jsonObj = new JSONObject();
        if (runParam != null && !runParam.equals("")) {
            jsonObj.put("runProperties", (JSONObject)new JSONParser().parse(runParam));
        }
        jsonObj.put("jobPid", Integer.parseInt(jobId));
        jsonObj.put("expireTimeInMinutes", expireTimeInMinutes);
        StringEntity requestEntity = new StringEntity(jsonObj.toJSONString(), ContentType.APPLICATION_JSON);
        return requestEntity;
    }

    public String getRunParamJsonPayload(String runParamStr) {
        if (runParamStr == null || runParamStr.trim().length() == 0) {
            return null;
        }
        try {
            new JSONParser().parse(runParamStr);
            return runParamStr;
        }
        catch (Exception e) {
            String[] splitOnAmp;
            JSONObject json = new JSONObject();
            for (String split : splitOnAmp = runParamStr.split("&")) {
                String[] splitOnEquals = split.split("=");
                if (splitOnEquals.length != 2) continue;
                String key = splitOnEquals[0].trim();
                String value = splitOnEquals[1].trim();
                if (key.equals("") || value.equals("")) continue;
                json.put(key, value);
            }
            return json.toJSONString();
        }
    }

    public String getFormattedTime(long a, long b) {
        Date startDate = new Date(a);
        Date endDate = new Date(b);
        long difference_In_Time = endDate.getTime() - startDate.getTime();
        long difference_In_Seconds = difference_In_Time / 1000L % 60L;
        long difference_In_Minutes = difference_In_Time / 60000L % 60L;
        long difference_In_Hours = difference_In_Time / 3600000L % 24L;
        long difference_In_Days = difference_In_Time / 86400000L % 365L;
        String res = "";
        if (difference_In_Days != Long.valueOf(0L)) {
            res = res + (difference_In_Days > Long.valueOf(1L) ? difference_In_Days + " days" : difference_In_Days + " day");
        }
        if (difference_In_Hours != Long.valueOf(0L)) {
            res = res + (difference_In_Hours > Long.valueOf(1L) ? difference_In_Hours + " hrs" : difference_In_Hours + " hr");
        }
        if (difference_In_Minutes != Long.valueOf(0L)) {
            res = res + " " + (difference_In_Minutes > Long.valueOf(1L) ? difference_In_Minutes + " mins" : difference_In_Minutes + " min");
        }
        if (difference_In_Seconds != Long.valueOf(0L)) {
            res = res + " " + (difference_In_Seconds > Long.valueOf(1L) ? difference_In_Seconds + " seconds" : difference_In_Seconds + " second");
        }
        return res;
    }

    public boolean isWaitTimeExceeded(long start, int maxWait) {
        return Math.floor((System.currentTimeMillis() - start) / 60000L) > (double)maxWait;
    }
}

