/*
 * Decompiled with CFR 0.152.
 */
package aqPluginCore;

import aqPluginCore.AQUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class AQRestClient {
    private static final AQRestClient aqRESTClient = new AQRestClient();
    private final JSONParser jsonParser = new JSONParser();
    private static String BASE_URL;
    private static String API_ENDPOINT;
    private static int PROXY_PORT;
    private static String PROXY_HOST;
    private static Boolean DISABLE_SSL_CHECKS;

    public static AQRestClient getInstance() {
        return aqRESTClient;
    }

    public String getBaseURL() {
        return BASE_URL;
    }

    public String getResultExternalAccessURL(String jobPid, String tenantCode) {
        return String.format(this.getBaseURL() + "#/resultext?tenant=%s&resultId=%s", tenantCode, jobPid);
    }

    public String getAbortURL(String jobPid) {
        return String.format(this.getBaseURL() + "#/forward?entityType=9&resultId=%s", jobPid);
    }

    public void setUpBaseURL(String baseURL, String tenantCode) {
        BASE_URL = baseURL.charAt(baseURL.length() - 1) == '/' ? baseURL : baseURL + '/';
        API_ENDPOINT = BASE_URL + "awb/api/" + "1.0" + "/" + tenantCode;
    }

    private CloseableHttpClient getHttpsClient() {
        try {
            HttpClientBuilder hcb = null;
            if (DISABLE_SSL_CHECKS.booleanValue()) {
                SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                    @Override
                    public boolean isTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                        return true;
                    }
                }).build();
                hcb = HttpClients.custom().setSSLContext(sslContext).setSSLHostnameVerifier(new NoopHostnameVerifier());
            } else {
                hcb = HttpClients.custom().setSSLContext(SSLContext.getDefault()).setSSLHostnameVerifier(new DefaultHostnameVerifier());
            }
            if (PROXY_HOST != null && !PROXY_HOST.equals("")) {
                HttpHost hh = new HttpHost(PROXY_HOST, PROXY_PORT);
                hcb.setProxy(hh);
            }
            CloseableHttpClient client = hcb.build();
            return client;
        }
        catch (Exception e) {
            return null;
        }
    }

    public JSONObject getJobSummary(long runPid, String apiKey, String userId) {
        CloseableHttpClient httpClient = this.getHttpsClient();
        HttpGet httpGet = new HttpGet(API_ENDPOINT + "/runs/" + runPid);
        httpGet.addHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.103 Safari/537.36");
        httpGet.addHeader("API_KEY", apiKey);
        httpGet.addHeader("USER_ID", userId);
        httpGet.addHeader("Content-Type", "application/json");
        try {
            CloseableHttpResponse httpResponse = httpClient.execute(httpGet);
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode >= 200 && statusCode <= 299) {
                String inputLine;
                BufferedReader reader = new BufferedReader(new InputStreamReader(httpResponse.getEntity().getContent(), StandardCharsets.UTF_8));
                StringBuffer response = new StringBuffer();
                while ((inputLine = reader.readLine()) != null) {
                    response.append(inputLine);
                }
                reader.close();
                JSONObject summaryObj = (JSONObject)this.jsonParser.parse(response.toString());
                httpClient.close();
                return summaryObj;
            }
            JSONObject errorObj = new JSONObject();
            errorObj.put("aq_statusCode", statusCode);
            httpClient.close();
            return errorObj;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject triggerJob(String apiKey, String userId, String jobId, String runParam, int maxWaitTime) throws IOException, ParseException {
        JSONObject jSONObject;
        CloseableHttpClient httpClient = this.getHttpsClient();
        HttpPut httpPut = new HttpPut(API_ENDPOINT + "/jobs/" + jobId + "/trigger-ci-job");
        httpPut.addHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.103 Safari/537.36");
        httpPut.addHeader("API_KEY", apiKey);
        httpPut.addHeader("USER_ID", userId);
        httpPut.addHeader("Content-Type", "application/json");
        httpPut.setEntity(new AQUtils().getRunParam(jobId, runParam, maxWaitTime));
        try {
            String inputLine;
            CloseableHttpResponse httpResponse = httpClient.execute(httpPut);
            BufferedReader reader = new BufferedReader(new InputStreamReader(httpResponse.getEntity().getContent()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = reader.readLine()) != null) {
                response.append(inputLine);
            }
            reader.close();
            JSONArray jobInfo = (JSONArray)this.jsonParser.parse(response.toString());
            if (httpResponse.getStatusLine().getStatusCode() == 200 || httpResponse.getStatusLine().getStatusCode() == 204) {
                JSONObject obj = new JSONObject();
                obj.put("pid", jobInfo.get(0));
                JSONObject jSONObject2 = obj;
                return jSONObject2;
            }
            JSONObject jSONObject3 = (JSONObject)this.jsonParser.parse(response.toString());
            return jSONObject3;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            jSONObject = null;
            return jSONObject;
        }
        catch (Exception pe) {
            pe.printStackTrace();
            jSONObject = null;
            return jSONObject;
        }
        finally {
            httpClient.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String testConnection(String apiKey, String userId, String jobId, String runParam, int maxWaitTime) throws ParseException, IOException {
        CloseableHttpClient httpClient = this.getHttpsClient();
        HttpPost httpPost = new HttpPost(API_ENDPOINT + "/jobs/" + jobId + "/validate-ci-job");
        httpPost.addHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.103 Safari/537.36");
        httpPost.addHeader("API_KEY", apiKey);
        httpPost.addHeader("USER_ID", userId);
        httpPost.addHeader("Content-Type", "application/json");
        httpPost.setEntity(new AQUtils().getRunParam(jobId, runParam, maxWaitTime));
        try {
            CloseableHttpResponse httpResponse = httpClient.execute(httpPost);
            if (httpResponse.getStatusLine().getStatusCode() == 200 || httpResponse.getStatusLine().getStatusCode() == 204) {
                String string = "";
                return string;
            }
            if (httpResponse.getStatusLine().getStatusCode() == 404) {
                String string = "Connection request failed. Please check the URL and Tenant Code.";
                return string;
            }
            if (httpResponse.getStatusLine().getStatusCode() == 401) {
                String string = "Connection request failed. Please check connection parameters.";
                return string;
            }
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                String string = "Template Job ID does not exist.";
                return string;
            }
            String string = "";
            return string;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            String string = null;
            return string;
        }
        catch (Exception pe) {
            pe.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            httpClient.close();
        }
    }

    public void setUpProxy(String proxyHost, int proxyPort) {
        PROXY_HOST = proxyHost;
        PROXY_PORT = proxyPort == 0 ? 80 : proxyPort;
    }

    public void disableSSLChecks(Boolean check) {
        DISABLE_SSL_CHECKS = check.booleanValue();
    }

    static {
        PROXY_PORT = 80;
        DISABLE_SSL_CHECKS = false;
    }
}

