/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.serverclient.impl;

import com.microfocus.sv.svconfigurator.core.IContentFile;
import com.microfocus.sv.svconfigurator.core.IDataModel;
import com.microfocus.sv.svconfigurator.core.IDataSet;
import com.microfocus.sv.svconfigurator.core.ILoggedServiceCallList;
import com.microfocus.sv.svconfigurator.core.IPerfModel;
import com.microfocus.sv.svconfigurator.core.IProjectElement;
import com.microfocus.sv.svconfigurator.core.IService;
import com.microfocus.sv.svconfigurator.core.IServiceDescription;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommandExecutorException;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommunicatorException;
import com.microfocus.sv.svconfigurator.core.impl.exception.SVCParseException;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.AgentCapabilities;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.AgentCapability;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.AgentConfiguration;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.AgentConfigurations;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.ServerInfo;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.ServiceAnalysis;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.ServiceRuntimeConfiguration;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.ServiceRuntimeReport;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.ServiceRuntimeReports;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.VirtualServiceLoggingConfiguration;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.atom.DataSetEntry;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.atom.ElemModelListAtom;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.atom.ServiceListAtom;
import com.microfocus.sv.svconfigurator.core.impl.processor.ElementStatus;
import com.microfocus.sv.svconfigurator.serverclient.FileInfo;
import com.microfocus.sv.svconfigurator.serverclient.IRestClient;
import com.microfocus.sv.svconfigurator.serverclient.IServerManagementEndpointClient;
import com.microfocus.sv.svconfigurator.serverclient.ServerCompatibility;
import com.microfocus.sv.svconfigurator.util.URIUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ServerManagementEndpointClient
implements IServerManagementEndpointClient {
    private static final String SV_VERSION = "3.0";
    private static final String REL_URL_PING = "ping";
    private static final String REL_URL_INFO = "info";
    private static final String REL_URL_AGENT_CONFIG = "agents/configurations";
    private static final String REL_URL_AGENT_CAPABILITIES = "agents/agentCapabilities";
    private static final String REL_URL_SERVICE = "services/%s?alt=xml";
    private static final String REL_URL_SERVICES = "services";
    private static final String REL_URL_SERVICE_LIST = "services?onlyActiveServices=false&projectIds=%s";
    private static final String REL_URL_SERVICE_ANALYSIS = "services/%s/analysis";
    private static final String REL_URL_3_01_SERVICE_REPORT = "services/%s/report";
    private static final String REL_URL_3_10_SERVICE_REPORT = "services/%s/runtimeReport";
    private static final String REL_URL_3_61_SERVICE_REPORT = "runtimeReports?virtualServiceIds=%s&onlyActiveServices=false";
    private static final String REL_URL_DATA_MODELS_LIST_ATOM = "dataModels?virtualServiceIds=%s&onlyActiveServices=false";
    private static final String REL_URL_DATA_MODELS = "services/%s/dataModel";
    private static final String REL_URL_GET_DATA_MODELS = "services/%s/dataModels?alt=xml";
    private static final String REL_URL_DATA_MODEL = "services/%s/dataModel/%s?alt=xml";
    private static final String REL_URL_PERF_MODELS = "services/%s/performanceModel";
    private static final String REL_URL_PERF_MODELS_LIST_ATOM = "performanceModels?virtualServiceIds=%s&onlyActiveServices=false";
    private static final String REL_URL_PERF_MODEL = "services/%s/performanceModel/%s?alt=xml";
    private static final String REL_URL_GET_PERF_MODELS = "services/%s/performanceModels?alt=xml";
    private static final String REL_URL_SVC_DESCS = "services/%s/serviceDescriptions";
    private static final String REL_URL_SVC_DESC = "services/%s/serviceDescriptions/%s?alt=xml";
    private static final String REL_URL_GET_SVC_DESCS = "serviceDescriptions?virtualServiceIds=%s";
    private static final String REL_URL_DATA_SETS = "services/%s/dataModel/%s/dataset";
    private static final String REL_URL_DATA_SET = "services/%s/dataModel/%s/dataset/%s?alt=xml";
    private static final String REL_URL_DATA_SET_ATOM = "services/%s/dataModel/%s/dataset/%s";
    private static final String REL_URL_GET_DATA_SETS = "services/%s/dataModel/%s/dataset";
    private static final String REL_URL_SVC_RUNTIME_CONF = "services/%s/runtimeConfiguration/";
    private static final String REL_URL_SVC_LOGGING_CONF = "services/%s/loggingConfiguration/";
    private static final String REL_URL_CONTENT_FILE = "services/%s/contentFiles";
    private static final String REL_URL_CONTENT_FILES = "services/%s/contentFiles/%s?alt=xml";
    private static final String REL_URL_CONTENT_FILES_INFO = "services/%s/contentFiles/%s";
    private static final String REL_URL_LOGGED_MESSAGES = "messageLogger/%s/impexp";
    private static final String REL_URL_LOGGED_MESSAGES_FROM_ID_LIMIT = "messageLogger/%s/impexp?from_id=%s&limit=%s";
    private static final Logger LOG = LoggerFactory.getLogger(ServerManagementEndpointClient.class);
    private String REL_URL_SERVICE_REPORT = "services/%s/runtimeReport";
    private final ServerCompatibility serverCompatibility;
    private final URL mgmtUri;
    private final IRestClient client;
    private final ServerInfo serverInfo;
    private final DocumentBuilderFactory docFactory;
    private final ThreadLocal<DocumentBuilder> threadLocalDocBuilder = new ThreadLocal();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ServerManagementEndpointClient(URL mgmtUrl, IRestClient client) throws CommunicatorException {
        if (!"http".equalsIgnoreCase(mgmtUrl.getProtocol()) && !"https".equalsIgnoreCase(mgmtUrl.getProtocol())) {
            throw new CommunicatorException("Management URL is not specified correctly (example: https://localhost:6085/management)");
        }
        this.mgmtUri = URIUtil.makeBase(mgmtUrl);
        this.client = client;
        this.pingServer();
        this.serverInfo = this.getServerInfoImpl();
        if (!SV_VERSION.equals(this.serverInfo.getServerVersion())) throw new CommunicatorException("Server's version you are using (" + this.serverInfo.getServerVersion() + ") is not supported by this tool.");
        String[] prodVersionStr = this.serverInfo.getProductVersion().split("\\.");
        int[] prodVersion = new int[prodVersionStr.length];
        for (int i = 0; i < prodVersion.length; ++i) {
            prodVersion[i] = Integer.valueOf(prodVersionStr[i]);
        }
        if (prodVersion[0] == 3 && prodVersion[1] >= 61 || prodVersion[0] >= 4) {
            this.REL_URL_SERVICE_REPORT = REL_URL_3_61_SERVICE_REPORT;
            this.serverCompatibility = ServerCompatibility.SV_3_61_PLUS;
        } else if (prodVersion[0] == 3 && prodVersion[1] >= 10) {
            this.REL_URL_SERVICE_REPORT = REL_URL_3_10_SERVICE_REPORT;
            this.serverCompatibility = ServerCompatibility.SV_3_10;
        } else {
            if (prodVersion[0] != 3 || prodVersion[1] >= 10) throw new CommunicatorException("Server's product version you are using (" + this.serverInfo.getProductVersion() + ") is not supported by this tool.");
            this.REL_URL_SERVICE_REPORT = REL_URL_3_01_SERVICE_REPORT;
            this.serverCompatibility = ServerCompatibility.SV_3_10_LESS;
        }
        this.docFactory = DocumentBuilderFactory.newInstance();
    }

    @Override
    public URL getMgmtUri() {
        return this.mgmtUri;
    }

    @Override
    public IRestClient getClient() {
        return this.client;
    }

    private DocumentBuilder getLocalBuilder() {
        try {
            DocumentBuilder builder = this.threadLocalDocBuilder.get();
            if (builder == null) {
                builder = this.docFactory.newDocumentBuilder();
                this.threadLocalDocBuilder.set(builder);
            }
            return builder;
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document deserializeXml(byte[] data) throws ParserConfigurationException, SAXException, IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        try {
            Document document = this.getLocalBuilder().parse(bis);
            return document;
        }
        finally {
            IOUtils.closeQuietly(bis);
        }
    }

    @Override
    public ServerCompatibility getServerCompatibility() {
        return this.serverCompatibility;
    }

    @Override
    public ServerInfo getServerInfo() {
        return this.serverInfo;
    }

    private ServerInfo getServerInfoImpl() throws CommunicatorException {
        URI infoUri = this.resolveRelativeUri(REL_URL_INFO);
        return this.client.get(infoUri, ContentType.APPLICATION_ATOM_XML, ServerInfo.class);
    }

    @Override
    public AgentConfigurations getAgentConfigurations() throws CommunicatorException {
        URI configUrl = this.resolveRelativeUri(REL_URL_AGENT_CONFIG);
        AgentConfigurations agentConfigurations = this.client.get(configUrl, ContentType.APPLICATION_XML, AgentConfigurations.class);
        URI capabilityUrl = this.resolveRelativeUri(REL_URL_AGENT_CAPABILITIES);
        AgentCapabilities agentCapabilities = this.client.get(capabilityUrl, ContentType.APPLICATION_XML, AgentCapabilities.class);
        HashSet<String> enabledAgents = new HashSet<String>();
        for (AgentCapability cap : agentCapabilities.getCapabilities()) {
            enabledAgents.add(cap.getAgentId());
        }
        for (AgentConfiguration conf : agentConfigurations.getConfigurations()) {
            conf.setRunning(enabledAgents.contains(conf.getAgentId()));
        }
        return agentConfigurations;
    }

    @Override
    public ServiceListAtom getServiceList(String projectId) throws CommunicatorException {
        URI uri;
        try {
            uri = this.resolveRelativeUri(String.format(REL_URL_SERVICE_LIST, projectId != null ? URLEncoder.encode(projectId, "UTF-8") : ""));
        }
        catch (UnsupportedEncodingException e) {
            throw new CommunicatorException("URL encoding exception: " + e.getLocalizedMessage(), e);
        }
        return this.client.get(uri, ContentType.APPLICATION_ATOM_XML, ServiceListAtom.class);
    }

    @Override
    public ServiceAnalysis getServiceAnalysis(IService svc) throws CommunicatorException {
        URI uri = this.resolveRelativeUri(String.format(REL_URL_SERVICE_ANALYSIS, svc.getId()));
        return this.client.get(uri, ServiceAnalysis.class);
    }

    @Override
    public void setServiceAnalysis(IService svc, ServiceAnalysis sa) throws CommunicatorException {
        URI uri = this.resolveRelativeUri(String.format(REL_URL_SERVICE_ANALYSIS, svc.getId()));
        this.client.put(uri, sa);
    }

    @Override
    public ElementStatus getServiceStatus(IService svc) throws CommunicatorException {
        URI svcUri = this.resolveRelativeUri(String.format(REL_URL_SERVICE, svc.getId()));
        return this.client.getStatus(svcUri);
    }

    @Override
    public ServiceRuntimeReport getServiceRuntimeReport(IService svc) throws CommunicatorException {
        URI svcUri = this.resolveRelativeUri(String.format(this.REL_URL_SERVICE_REPORT, svc.getId()));
        if (this.REL_URL_SERVICE_REPORT.equals(REL_URL_3_61_SERVICE_REPORT)) {
            ServiceRuntimeReports reports = this.client.get(svcUri, ContentType.APPLICATION_XML, ServiceRuntimeReports.class);
            if (reports != null && reports.getRuntimeReports() != null) {
                return reports.getRuntimeReports().get(0);
            }
            return new ServiceRuntimeReport();
        }
        return this.client.get(svcUri, ContentType.APPLICATION_XML, ServiceRuntimeReport.class);
    }

    @Override
    public void deployService(IService svc, String projectPassword) throws CommunicatorException {
        URI svcUri = this.resolveRelativeUri(REL_URL_SERVICES);
        this.deployElement(svc, svcUri);
    }

    @Override
    public void updateService(IService svc, String projectPassword) throws CommunicatorException {
        URI svcUri = this.resolveRelativeUri(String.format(REL_URL_SERVICE, svc.getId()));
        this.updateElement(svc, svcUri);
    }

    @Override
    public void undeployService(String serviceId) throws CommunicatorException {
        URI svcUri = this.resolveRelativeUri(String.format(REL_URL_SERVICE, serviceId));
        this.client.delete(svcUri);
    }

    @Override
    public ElementStatus getDataModelStatus(IDataModel dm) throws CommunicatorException {
        IService svc = dm.getService();
        URI dmUri = this.resolveRelativeUri(String.format(REL_URL_DATA_MODEL, svc.getId(), dm.getId()));
        return this.client.getStatus(dmUri);
    }

    @Override
    public ElemModelListAtom getSvcDataModelAtom(IService svc) throws CommunicatorException {
        URI u = this.resolveRelativeUri(String.format(REL_URL_DATA_MODELS_LIST_ATOM, svc.getId()));
        return this.client.get(u, ContentType.APPLICATION_ATOM_XML, ElemModelListAtom.class);
    }

    @Override
    public ElemModelListAtom getSvcPerfModelAtom(IService svc) throws CommunicatorException {
        URI u = this.resolveRelativeUri(String.format(REL_URL_PERF_MODELS_LIST_ATOM, svc.getId()));
        return this.client.get(u, ContentType.APPLICATION_ATOM_XML, ElemModelListAtom.class);
    }

    @Override
    public void deployDataModel(IDataModel dm, String projectPassword) throws CommunicatorException {
        IService svc = dm.getService();
        URI uri = this.resolveRelativeUri(String.format(REL_URL_DATA_MODELS, svc.getId()));
        this.deployElement(dm, uri);
    }

    @Override
    public void updateDataModel(IDataModel dm, String projectPassword) throws CommunicatorException {
        IService svc = dm.getService();
        URI uri = this.resolveRelativeUri(String.format(REL_URL_DATA_MODEL, svc.getId(), dm.getId()));
        this.updateElement(dm, uri);
    }

    @Override
    public ElementStatus getPerfModelStatus(IPerfModel pm) throws CommunicatorException {
        IService svc = pm.getService();
        URI uri = this.resolveRelativeUri(String.format(REL_URL_PERF_MODEL, svc.getId(), pm.getId()));
        return this.client.getStatus(uri);
    }

    @Override
    public void deployPerfModel(IPerfModel pm, String projectPassword) throws CommunicatorException {
        IService svc = pm.getService();
        URI uri = this.resolveRelativeUri(String.format(REL_URL_PERF_MODELS, svc.getId()));
        this.deployElement(pm, uri);
    }

    @Override
    public void updatePerfModel(IPerfModel pm, String projectPassword) throws CommunicatorException {
        IService svc = pm.getService();
        URI uri = this.resolveRelativeUri(String.format(REL_URL_PERF_MODEL, svc.getId(), pm.getId()));
        this.updateElement(pm, uri);
    }

    @Override
    public ElementStatus getServiceDescriptionStatus(IServiceDescription sd, IService svc) throws CommunicatorException {
        URI uri = this.resolveRelativeUri(String.format(REL_URL_SVC_DESC, svc.getId(), sd.getId()));
        return this.client.getStatus(uri);
    }

    @Override
    public void deployServiceDescription(IServiceDescription sd, IService svc, String projectPassword) throws CommunicatorException {
        URI uri = this.resolveRelativeUri(String.format(REL_URL_SVC_DESCS, svc.getId()));
        this.deployElement(sd, uri);
    }

    @Override
    public void updateServiceDescription(IServiceDescription sd, IService svc, String projectPassword) throws CommunicatorException {
        URI uri = this.resolveRelativeUri(String.format(REL_URL_SVC_DESC, svc.getId(), sd.getId()));
        this.updateElement(sd, uri);
    }

    @Override
    public ElementStatus getContentFileStatus(IContentFile cf, IService svc) throws CommunicatorException {
        URI uri = this.resolveRelativeUri(String.format(REL_URL_CONTENT_FILES_INFO, svc.getId(), cf.getId()));
        return this.client.getStatus(uri);
    }

    @Override
    public void deployContentFile(IContentFile cf, String projectPassword, IService svc) throws CommunicatorException {
        URI uri = this.resolveRelativeUri(String.format(REL_URL_CONTENT_FILE, svc.getId()));
        this.deployElement(cf, uri);
    }

    @Override
    public void updateContentFile(IContentFile cf, String projectPassword, IService svc) throws CommunicatorException {
        URI uri = this.resolveRelativeUri(String.format(REL_URL_CONTENT_FILES, svc.getId(), cf.getId()));
        this.updateElement(cf, uri);
    }

    @Override
    public ElementStatus getDataSetStatus(IDataSet ds) throws CommunicatorException {
        IDataModel dm = ds.getDataModel();
        IService svc = dm.getService();
        URI uri = this.resolveRelativeUri(String.format(REL_URL_DATA_SET, svc.getId(), dm.getId(), ds.getId()));
        return this.client.getStatus(uri);
    }

    @Override
    public long getDataSetHashCode(IDataSet ds) throws CommunicatorException {
        IDataModel dm = ds.getDataModel();
        IService s = dm.getService();
        URI u = this.resolveRelativeUri(String.format(REL_URL_DATA_SET_ATOM, s.getId(), dm.getId(), ds.getId()));
        DataSetEntry dsEntry = this.client.get(u, ContentType.APPLICATION_ATOM_XML, DataSetEntry.class);
        return dsEntry.getVersion();
    }

    @Override
    public void deployDataSet(IDataSet ds, String projectPassword) throws CommunicatorException {
        IDataModel dm = ds.getDataModel();
        IService svc = dm.getService();
        URI uri = this.resolveRelativeUri(String.format("services/%s/dataModel/%s/dataset", svc.getId(), dm.getId()));
        this.deployElement(ds, uri);
    }

    @Override
    public void updateDataSet(IDataSet ds, String projectPassword) throws CommunicatorException {
        IDataModel dm = ds.getDataModel();
        IService svc = dm.getService();
        URI uri = this.resolveRelativeUri(String.format(REL_URL_DATA_SET, svc.getId(), dm.getId(), ds.getId()));
        this.updateElement(ds, uri);
    }

    @Override
    public ServiceRuntimeConfiguration getServiceRuntimeConfiguration(IService svc) throws CommunicatorException {
        URI uri = this.resolveRelativeUri(String.format(REL_URL_SVC_RUNTIME_CONF, svc.getId()));
        return this.client.get(uri, ContentType.APPLICATION_XML, ServiceRuntimeConfiguration.class);
    }

    @Override
    public void setServiceRuntimeConfiguration(IService svc, ServiceRuntimeConfiguration configuration) throws CommunicatorException, CommandExecutorException {
        URI uri = this.resolveRelativeUri(String.format(REL_URL_SVC_RUNTIME_CONF, svc.getId()));
        this.client.put(uri, configuration, ContentType.APPLICATION_XML);
    }

    @Override
    public VirtualServiceLoggingConfiguration getVirtualServiceLoggingConfiguration(IService svc) throws CommunicatorException {
        URI uri = this.resolveRelativeUri(String.format(REL_URL_SVC_LOGGING_CONF, svc.getId()));
        return this.client.get(uri, ContentType.APPLICATION_XML, VirtualServiceLoggingConfiguration.class);
    }

    @Override
    public void setVirtualServiceLoggingConfiguration(IService svc, VirtualServiceLoggingConfiguration value) throws CommunicatorException {
        URI uri = this.resolveRelativeUri(String.format(REL_URL_SVC_LOGGING_CONF, svc.getId()));
        this.client.put(uri, value, ContentType.APPLICATION_XML);
    }

    private void deployElement(IProjectElement el, URI uri) throws CommunicatorException {
        LOG.debug(String.format("Deploying element %s [%s] to %s", el.getName(), el.getId(), uri));
        try {
            this.client.post(uri, el.getData(), el.getDataLength(), ContentType.APPLICATION_XML);
        }
        catch (IOException e) {
            throw new CommunicatorException(el + " data retrieve error: " + e.getLocalizedMessage(), e);
        }
        catch (SVCParseException e) {
            throw new CommunicatorException(el + " data retrieve error: " + e.getLocalizedMessage(), e);
        }
    }

    private void updateElement(IProjectElement el, URI uri) throws CommunicatorException {
        try {
            this.client.put(uri, el.getData(), el.getDataLength(), ContentType.APPLICATION_XML);
        }
        catch (IOException e) {
            throw new CommunicatorException(el + " data retrieve error: " + e.getLocalizedMessage(), e);
        }
        catch (SVCParseException e) {
            throw new CommunicatorException(el + " data retrieve error: " + e.getLocalizedMessage(), e);
        }
    }

    private URI resolveRelativeUri(String relative) throws CommunicatorException {
        try {
            URL base = this.mgmtUri;
            return base.toURI().resolve(relative);
        }
        catch (URISyntaxException e) {
            throw new CommunicatorException("Failed to create URI from '" + this.mgmtUri + "' and '" + relative + "'", e);
        }
    }

    private void pingServer() throws CommunicatorException {
        URI pingUri = this.resolveRelativeUri(REL_URL_PING);
        this.client.pingServer(pingUri);
        LOG.debug("Server ping successful.");
    }

    @Override
    public byte[] fetchVirtualService(String vsId) throws CommunicatorException {
        URI svcUri = this.resolveRelativeUri(String.format(REL_URL_SERVICE, vsId));
        return this.client.getPayload(svcUri, ContentType.APPLICATION_XML);
    }

    @Override
    public byte[] fetchServiceDescription(String vsId, String sdId) throws CommunicatorException {
        URI svcUri = this.resolveRelativeUri(String.format(REL_URL_SVC_DESC, vsId, sdId));
        return this.client.getPayload(svcUri, ContentType.APPLICATION_XML);
    }

    @Override
    public byte[] fetchContentFile(String vsId, String cfId) throws CommunicatorException {
        URI svcUri = this.resolveRelativeUri(String.format(REL_URL_CONTENT_FILES, vsId, cfId));
        return this.client.getPayload(svcUri, ContentType.APPLICATION_XML);
    }

    @Override
    public byte[] fetchDataModel(String vsId, String dmId) throws CommunicatorException {
        URI svcUri = this.resolveRelativeUri(String.format(REL_URL_DATA_MODEL, vsId, dmId));
        return this.client.getPayload(svcUri, ContentType.APPLICATION_XML);
    }

    @Override
    public byte[] fetchDataSet(String vsId, String dmId, String dsId) throws CommunicatorException {
        URI svcUri = this.resolveRelativeUri(String.format(REL_URL_DATA_SET, vsId, dmId, dsId));
        return this.client.getPayload(svcUri, ContentType.APPLICATION_XML);
    }

    @Override
    public byte[] fetchPerformanceModel(String vsId, String pmId) throws CommunicatorException {
        URI svcUri = this.resolveRelativeUri(String.format(REL_URL_PERF_MODEL, vsId, pmId));
        return this.client.getPayload(svcUri, ContentType.APPLICATION_XML);
    }

    @Override
    public FileInfo fetchLoggedMessages(String vsId, long from, int limit) throws CommunicatorException {
        URI uri = this.resolveRelativeUri(String.format(REL_URL_LOGGED_MESSAGES_FROM_ID_LIMIT, vsId, from, limit));
        return this.client.getFileInfo(uri, ContentType.APPLICATION_XML);
    }

    @Override
    public void resetLoggedMessagesForService(String vsId) throws CommunicatorException {
        URI uri = this.resolveRelativeUri(String.format(REL_URL_LOGGED_MESSAGES, vsId));
        this.client.delete(uri);
    }

    @Override
    public void importLoggedMessages(ILoggedServiceCallList loggedServiceCallList) throws CommunicatorException {
        URI uri = this.resolveRelativeUri(String.format(REL_URL_LOGGED_MESSAGES, loggedServiceCallList.VsId()));
        try {
            this.client.post(uri, loggedServiceCallList.getData(), loggedServiceCallList.getDataLength(), ContentType.APPLICATION_XML);
        }
        catch (IOException e) {
            throw new CommunicatorException(loggedServiceCallList + " data retrieve error: " + e.getLocalizedMessage(), e);
        }
        catch (SVCParseException e) {
            throw new CommunicatorException(loggedServiceCallList + " data retrieve error: " + e.getLocalizedMessage(), e);
        }
    }

    private Collection<String> fetchItems(URI uri) throws CommunicatorException {
        try {
            byte[] data = this.client.getPayload(uri, null);
            Document doc = this.deserializeXml(data);
            ArrayList<String> items = new ArrayList<String>();
            Node feed = this.findNext(doc.getFirstChild(), "feed");
            if (feed == null) {
                throw new IllegalArgumentException("Failed to get feed element");
            }
            Node entry = feed.getFirstChild();
            while ((entry = this.findNext(entry, "entry")) != null) {
                Node id = this.findNext(entry.getFirstChild(), "id");
                items.add(id.getTextContent().trim());
                entry = entry.getNextSibling();
            }
            return items;
        }
        catch (CommunicatorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot get fetch item list for '" + uri + "'", e);
        }
    }

    @Override
    public Collection<String> getServiceDescriptionIds(String vsId) throws CommunicatorException {
        return this.fetchItems(this.resolveRelativeUri(String.format(REL_URL_GET_SVC_DESCS, vsId)));
    }

    private Node findNext(Node node, String name) {
        if (node == null) {
            return null;
        }
        Node x = node;
        do {
            if (!x.getNodeName().endsWith(name)) continue;
            return x;
        } while ((x = x.getNextSibling()) != null);
        return null;
    }

    @Override
    public Collection<String> getDataModelIds(String vsId) throws CommunicatorException {
        return this.fetchItems(this.resolveRelativeUri(String.format(REL_URL_GET_DATA_MODELS, vsId)));
    }

    @Override
    public Collection<String> getDataSetIds(String vsId, String dmId) throws CommunicatorException {
        return this.fetchItems(this.resolveRelativeUri(String.format("services/%s/dataModel/%s/dataset", vsId, dmId)));
    }

    @Override
    public Collection<String> getPerformanceModelIds(String vsId) throws CommunicatorException {
        return this.fetchItems(this.resolveRelativeUri(String.format(REL_URL_GET_PERF_MODELS, vsId)));
    }
}

