/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.serverclient.impl;

import com.microfocus.sv.svconfigurator.core.impl.exception.CommunicatorException;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.ExceptionTransferHolder;
import com.microfocus.sv.svconfigurator.core.impl.processor.Credentials;
import com.microfocus.sv.svconfigurator.core.impl.processor.ElementStatus;
import com.microfocus.sv.svconfigurator.serverclient.FileInfo;
import com.microfocus.sv.svconfigurator.serverclient.IJaxbProcessor;
import com.microfocus.sv.svconfigurator.serverclient.IRestClient;
import com.microfocus.sv.svconfigurator.serverclient.impl.JaxbProcessor;
import com.microfocus.sv.svconfigurator.util.HttpMessageUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClient
implements IRestClient {
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private static final String FILENAME_PREFIX = "filename=";
    private static Logger LOG = LoggerFactory.getLogger(RestClient.class);
    private Credentials cred;
    private HttpClient client;
    private IJaxbProcessor jaxbProc;

    public RestClient(Credentials cred, HttpClient httpClient) {
        this.cred = cred;
        this.client = httpClient;
        this.jaxbProc = new JaxbProcessor();
    }

    @Override
    public String getUsername() {
        if (this.cred != null) {
            return this.cred.getUsername();
        }
        return null;
    }

    @Override
    public void post(URI uri, Object entity) throws CommunicatorException {
        LOG.debug("POST: " + uri);
        HttpPost post = new HttpPost(uri);
        this.executeJaxbSend(post, entity);
    }

    @Override
    public void post(URI uri, InputStream data, long dataLength, ContentType ct) throws CommunicatorException {
        LOG.debug("POST: " + uri);
        HttpPost post = new HttpPost(uri);
        this.executeStreamSend(post, data, dataLength, ct);
    }

    @Override
    public void put(URI uri, Object entity) throws CommunicatorException {
        LOG.debug("PUT: " + uri);
        HttpPut put = new HttpPut(uri);
        this.executeJaxbSend(put, entity);
    }

    @Override
    public void put(URI uri, Object entity, ContentType accept) throws CommunicatorException {
        LOG.debug("PUT: " + uri);
        HttpPut put = new HttpPut(uri);
        if (accept != null) {
            HttpMessageUtil.accept(put, ContentType.APPLICATION_XML);
        }
        this.executeJaxbSend(put, entity);
    }

    @Override
    public void put(URI uri, InputStream data, long dataLength, ContentType ct) throws CommunicatorException {
        LOG.debug("PUT: " + uri);
        HttpPut put = new HttpPut(uri);
        this.executeStreamSend(put, data, dataLength, ct);
    }

    @Override
    public <E> E get(URI uri, Class<E> resType) throws CommunicatorException {
        return this.get(uri, ContentType.APPLICATION_XML, resType);
    }

    @Override
    public <E> E get(URI uri, ContentType accept, Class<E> resType) throws CommunicatorException {
        LOG.debug("GET: " + uri);
        HttpGet get = new HttpGet(uri);
        HttpMessageUtil.accept(get, accept);
        try {
            HttpResponse resp = this.exec(get);
            this.validateResponse(resp);
            return this.jaxbProc.unmasrhall(resp.getEntity().getContent(), resType);
        }
        catch (IOException e) {
            throw new CommunicatorException("Network error: " + e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void delete(URI uri) throws CommunicatorException {
        LOG.debug("DELETE " + uri);
        HttpDelete del = new HttpDelete(uri);
        try {
            HttpResponse response = this.exec(del);
            this.validateResponse(response);
            EntityUtils.consumeQuietly(response.getEntity());
        }
        catch (IOException e) {
            throw new CommunicatorException("Network error: " + e.getLocalizedMessage(), e);
        }
    }

    @Override
    public ElementStatus getStatus(URI uri) throws CommunicatorException {
        HttpResponse resp = this.get(uri, ContentType.APPLICATION_XML);
        int status = resp.getStatusLine().getStatusCode();
        EntityUtils.consumeQuietly(resp.getEntity());
        if (200 == status) {
            return ElementStatus.PRESENT;
        }
        if (400 == status || 404 == status) {
            return ElementStatus.NOT_PRESENT;
        }
        try {
            this.validateResponse(resp);
        }
        catch (CommunicatorException e) {
            if (e.getStatusCode() == 403) {
                return ElementStatus.NOT_PRESENT;
            }
            throw e;
        }
        return ElementStatus.NOT_PRESENT;
    }

    @Override
    public void pingServer(URI pingUrl) throws CommunicatorException {
        HttpResponse resp = this.get(pingUrl, ContentType.APPLICATION_XML);
        int status = resp.getStatusLine().getStatusCode();
        EntityUtils.consumeQuietly(resp.getEntity());
        if (403 == status) {
            throw new CommunicatorException("Bad username or password.", status);
        }
        this.validateResponse(resp);
    }

    private void executeStreamSend(HttpEntityEnclosingRequestBase req, InputStream data, long dataLength, ContentType ct) throws CommunicatorException {
        HttpMessageUtil.contentType(req, ct);
        req.setEntity(new InputStreamEntity(data, dataLength, ct));
        this.executeSend(req);
    }

    private void executeJaxbSend(HttpEntityEnclosingRequestBase req, Object entity) throws CommunicatorException {
        HttpMessageUtil.contentType(req, ContentType.APPLICATION_XML);
        try {
            String entStr = this.jaxbProc.marshall(entity);
            req.setEntity(new StringEntity(entStr));
        }
        catch (IOException e) {
            throw new CommunicatorException("Error during entity serialization: " + e.getLocalizedMessage(), e);
        }
        this.executeSend(req);
    }

    private void executeSend(HttpRequestBase req) throws CommunicatorException {
        try {
            HttpResponse resp = this.exec(req);
            this.validateResponse(resp);
            EntityUtils.consumeQuietly(resp.getEntity());
        }
        catch (IOException e) {
            throw new CommunicatorException("Network error: " + e.getLocalizedMessage(), e);
        }
    }

    private HttpResponse get(URI uri, ContentType accept) throws CommunicatorException {
        LOG.debug("GET " + uri);
        HttpGet httpget = new HttpGet(uri);
        if (accept != null) {
            HttpMessageUtil.accept(httpget, accept);
        }
        try {
            HttpResponse response = this.exec(httpget);
            return response;
        }
        catch (SSLPeerUnverifiedException e) {
            throw new CommunicatorException("Unable to create SSL connection to SV server. This may be caused by SV server running on newer Windows and SVConfigurator with old Java which may not support newer cipher suites required by the server. Detail: " + e.getLocalizedMessage(), e);
        }
        catch (IOException e) {
            throw new CommunicatorException("Network error: " + e.getLocalizedMessage(), e);
        }
    }

    private void validateResponse(HttpResponse resp) throws CommunicatorException {
        int status = resp.getStatusLine().getStatusCode();
        if (200 != status) {
            throw this.createException(resp);
        }
    }

    private CommunicatorException createException(HttpResponse resp) {
        int status = resp.getStatusLine().getStatusCode();
        if (status == 401) {
            return new CommunicatorException("Bad username or password.", status);
        }
        if (status == 403) {
            return new CommunicatorException("You are unauthorized to perform the current operation. Please, check your credentials and assigned permissions.", status);
        }
        if (status == 405) {
            return new CommunicatorException("Server returned Method not found (HTTP 405) result. Please, check your server management URL.", status);
        }
        if (status == 400) {
            ExceptionTransferHolder eth;
            HttpEntity entity = resp.getEntity();
            try {
                eth = this.jaxbProc.unmasrhall(entity.getContent(), ExceptionTransferHolder.class);
            }
            catch (IOException ex) {
                return new CommunicatorException("Network error: " + ex.getLocalizedMessage(), status, ex);
            }
            catch (CommunicatorException ex) {
                return new CommunicatorException("Error during server error response read (status = " + status + "): " + ex.getLocalizedMessage(), status, ex);
            }
            return new CommunicatorException("Server error response: " + eth.getMessage(), status);
        }
        return new CommunicatorException("Response with error code " + status + " received", status);
    }

    private HttpResponse exec(HttpRequestBase req) throws IOException {
        if (this.cred != null) {
            HttpMessageUtil.basicAuthentication(req, this.cred);
        }
        return this.client.execute(req);
    }

    @Override
    public byte[] getPayload(URI uri, ContentType accept) throws CommunicatorException {
        LOG.debug("GET " + uri);
        HttpGet httpget = new HttpGet(uri);
        if (accept != null) {
            HttpMessageUtil.accept(httpget, ContentType.APPLICATION_XML);
        }
        try {
            HttpResponse response = this.exec(httpget);
            if (response.getStatusLine().getStatusCode() != 200) {
                EntityUtils.consumeQuietly(response.getEntity());
                throw new CommunicatorException(String.format("GET of %s failed: %s", uri, response.getStatusLine()));
            }
            return EntityUtils.toByteArray(response.getEntity());
        }
        catch (IOException e) {
            throw new CommunicatorException("Network error: " + e.getLocalizedMessage(), e);
        }
    }

    @Override
    public FileInfo getFileInfo(URI uri, ContentType accept) throws CommunicatorException {
        LOG.debug("GET " + uri);
        HttpGet httpget = new HttpGet(uri);
        if (accept != null) {
            HttpMessageUtil.accept(httpget, ContentType.APPLICATION_XML);
        }
        try {
            HttpResponse response = this.exec(httpget);
            if (response.getStatusLine().getStatusCode() != 200) {
                EntityUtils.consumeQuietly(response.getEntity());
                throw new CommunicatorException(String.format("GET of %s failed: %s", uri, response.getStatusLine()));
            }
            byte[] content = EntityUtils.toByteArray(response.getEntity());
            Header[] contentDispositionHeaders = response.getHeaders(CONTENT_DISPOSITION);
            if (contentDispositionHeaders == null || contentDispositionHeaders.length == 0) {
                return null;
            }
            String contentDisposition = contentDispositionHeaders[0].getValue();
            return new FileInfo(this.parseFileName(contentDisposition), content);
        }
        catch (IOException e) {
            throw new CommunicatorException("Network error: " + e.getLocalizedMessage(), e);
        }
    }

    private String parseFileName(String contentDisposition) throws CommunicatorException {
        String[] values;
        for (String item : values = contentDisposition.split(";")) {
            String trimmed = item.trim();
            if (!trimmed.startsWith(FILENAME_PREFIX)) continue;
            return trimmed.substring(FILENAME_PREFIX.length());
        }
        throw new CommunicatorException("Network error: invalid Content-Disposition header: " + contentDisposition);
    }
}

