/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.serverclient.impl;

import com.microfocus.sv.svconfigurator.core.impl.exception.CommunicatorException;
import com.microfocus.sv.svconfigurator.serverclient.IJaxbProcessor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class JaxbProcessor
implements IJaxbProcessor {
    private static Logger LOG = LoggerFactory.getLogger(JaxbProcessor.class);
    private Map<Class<?>, JAXBContext> contexts = new HashMap();
    private DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();

    public JaxbProcessor() {
        this.dbf.setExpandEntityReferences(false);
        this.dbf.setNamespaceAware(true);
    }

    @Override
    public String marshall(Object o) throws CommunicatorException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.marshall(o, baos);
        try {
            baos.close();
            return baos.toString();
        }
        catch (IOException e) {
            throw new CommunicatorException("Error during marshalling");
        }
    }

    @Override
    public void marshall(Object o, OutputStream os) throws CommunicatorException {
        try {
            Marshaller m = this.getContext(o.getClass()).createMarshaller();
            m.marshal(o, os);
        }
        catch (JAXBException e) {
            throw new CommunicatorException("Error during object marshalling", e);
        }
    }

    @Override
    public <T> T unmasrhall(InputStream is, Class<T> cls) throws CommunicatorException {
        try {
            DocumentBuilder db = this.dbf.newDocumentBuilder();
            Document document = db.parse(is);
            Unmarshaller u = this.getContext(cls).createUnmarshaller();
            Object object = u.unmarshal((Node)document);
            return (T)object;
        }
        catch (JAXBException e) {
            throw new CommunicatorException("Error during stream unmarshalling.", e);
        }
        catch (IOException e) {
            throw new CommunicatorException("Error during stream unmarshalling.", e);
        }
        catch (ParserConfigurationException e) {
            throw new CommunicatorException("Error during stream unmarshalling.", e);
        }
        catch (SAXException e) {
            throw new CommunicatorException("Error during stream unmarshalling.", e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                LOG.error("Error during InputStream closing.", e);
            }
        }
    }

    private JAXBContext getContext(Class<?> cls) throws CommunicatorException {
        if (!this.contexts.containsKey(cls)) {
            try {
                this.contexts.put(cls, JAXBContext.newInstance((Class[])new Class[]{cls}));
            }
            catch (JAXBException e) {
                throw new CommunicatorException("Error during JaxbContext initialization: " + e.getLocalizedMessage(), e);
            }
        }
        return this.contexts.get(cls);
    }
}

